/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.spi.ExecutionContext;

public class JdbcExecHelper {
    public static final JdbcExecHelper INSTANCE = new JdbcExecHelper();

    private JdbcExecHelper() {
    }

    public static CacheMode resolveCacheMode(ExecutionContext executionContext) {
        return JdbcExecHelper.resolveCacheMode(executionContext.getQueryOptions(), executionContext.getSession());
    }

    public static CacheMode resolveCacheMode(QueryOptions options, SharedSessionContractImplementor session) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> options == null ? null : options.getCacheMode();
        supplierArray[1] = session::getCacheMode;
        supplierArray[2] = () -> CacheMode.NORMAL;
        return (CacheMode)((Object)NullnessHelper.coalesceSuppliedValues(supplierArray));
    }

    public static CacheMode resolveCacheMode(CacheMode override, SharedSessionContractImplementor session) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> override;
        supplierArray[1] = session::getCacheMode;
        supplierArray[2] = () -> CacheMode.NORMAL;
        return (CacheMode)((Object)NullnessHelper.coalesceSuppliedValues(supplierArray));
    }
}

