/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.util.Collections;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.ClassUtils;

class EntityManagerRuntimeHints
implements RuntimeHintsRegistrar {
    private static final String HIBERNATE_SESSION_FACTORY_CLASS_NAME = "org.hibernate.SessionFactory";
    private static final String ENTITY_MANAGER_FACTORY_CLASS_NAME = "jakarta.persistence.EntityManagerFactory";
    private static final String QUERY_SQM_IMPL_CLASS_NAME = "org.hibernate.query.sqm.internal.QuerySqmImpl";
    private static final String NATIVE_QUERY_IMPL_CLASS_NAME = "org.hibernate.query.sql.internal.NativeQueryImpl";

    EntityManagerRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        Class clazz2;
        if (ClassUtils.isPresent((String)HIBERNATE_SESSION_FACTORY_CLASS_NAME, (ClassLoader)classLoader)) {
            hints.proxies().registerJdkProxy(new TypeReference[]{TypeReference.of((String)HIBERNATE_SESSION_FACTORY_CLASS_NAME), TypeReference.of(EntityManagerFactoryInfo.class)});
            hints.proxies().registerJdkProxy(new TypeReference[]{TypeReference.of((String)"org.hibernate.Session"), TypeReference.of(EntityManagerProxy.class)});
        }
        if (ClassUtils.isPresent((String)ENTITY_MANAGER_FACTORY_CLASS_NAME, (ClassLoader)classLoader)) {
            hints.reflection().registerType(TypeReference.of((String)ENTITY_MANAGER_FACTORY_CLASS_NAME), builder -> {
                builder.onReachableType(SharedEntityManagerCreator.class).withMethod("getCriteriaBuilder", Collections.emptyList(), ExecutableMode.INVOKE);
                builder.onReachableType(SharedEntityManagerCreator.class).withMethod("getMetamodel", Collections.emptyList(), ExecutableMode.INVOKE);
            });
        }
        try {
            clazz2 = ClassUtils.forName((String)QUERY_SQM_IMPL_CLASS_NAME, (ClassLoader)classLoader);
            hints.proxies().registerJdkProxy(ClassUtils.getAllInterfacesForClass((Class)clazz2, (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException clazz2) {
            // empty catch block
        }
        try {
            clazz2 = ClassUtils.forName((String)NATIVE_QUERY_IMPL_CLASS_NAME, (ClassLoader)classLoader);
            hints.proxies().registerJdkProxy(ClassUtils.getAllInterfacesForClass((Class)clazz2, (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

