/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.compile;

import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.shared.common.error.StandardException;

public abstract class OptimizerPlan {
    public static RowSource makeRowSource(UniqueTupleDescriptor uniqueTupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        if (uniqueTupleDescriptor == null) {
            return null;
        }
        if (uniqueTupleDescriptor instanceof ConglomerateDescriptor) {
            return new ConglomerateRS((ConglomerateDescriptor)uniqueTupleDescriptor, dataDictionary);
        }
        if (uniqueTupleDescriptor instanceof AliasDescriptor) {
            return new TableFunctionRS((AliasDescriptor)uniqueTupleDescriptor);
        }
        return null;
    }

    public abstract void bind(DataDictionary var1, LanguageConnectionContext var2, CompilerContext var3) throws StandardException;

    public abstract boolean isBound();

    public abstract int countLeafNodes();

    public abstract OptimizerPlan leftmostLeaf();

    public abstract boolean isLeftPrefixOf(OptimizerPlan var1);

    public static final class ConglomerateRS
    extends RowSource<ConglomerateDescriptor> {
        public ConglomerateRS(String string, String string2) {
            super(string, string2);
        }

        public ConglomerateRS(ConglomerateDescriptor conglomerateDescriptor, DataDictionary dataDictionary) throws StandardException {
            this._descriptor = conglomerateDescriptor;
            this._schema = dataDictionary.getSchemaDescriptor(conglomerateDescriptor.getSchemaID(), null);
            this._schemaName = this._schema.getSchemaName();
            this._rowSourceName = conglomerateDescriptor.getConglomerateName();
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
            super.bind(dataDictionary, languageConnectionContext, compilerContext);
            if (this._descriptor == null) {
                this._descriptor = dataDictionary.getConglomerateDescriptor(this._rowSourceName, this._schema, false);
            }
            if (this._descriptor == null) {
                throw StandardException.newException((String)"42X65", (Object[])new Object[]{this._schemaName + "." + this._rowSourceName});
            }
        }
    }

    public static final class TableFunctionRS
    extends RowSource<AliasDescriptor> {
        public TableFunctionRS(String string, String string2) {
            super(string, string2);
        }

        public TableFunctionRS(AliasDescriptor aliasDescriptor) {
            this._descriptor = aliasDescriptor;
            this._schemaName = aliasDescriptor.getSchemaName();
            this._rowSourceName = aliasDescriptor.getName();
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
            super.bind(dataDictionary, languageConnectionContext, compilerContext);
            if (this._descriptor == null) {
                this._descriptor = dataDictionary.getAliasDescriptor(this._schema.getUUID().toString(), this._rowSourceName, 'F');
            }
            if (this._descriptor == null) {
                throw StandardException.newException((String)"42X94", (Object[])new Object[]{AliasDescriptor.getAliasType('F'), this._schemaName + "." + this._rowSourceName});
            }
        }

        @Override
        public String toString() {
            return super.toString() + "()";
        }
    }

    public static abstract class RowSource<D extends UniqueTupleDescriptor>
    extends OptimizerPlan {
        protected String _schemaName;
        protected String _rowSourceName;
        protected SchemaDescriptor _schema;
        protected D _descriptor;

        public RowSource(String string, String string2) {
            this._schemaName = string;
            this._rowSourceName = string2;
        }

        protected RowSource() {
        }

        public D getDescriptor() {
            return this._descriptor;
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
            if (this._schema == null) {
                this._schema = StatementUtil.getSchemaDescriptor(this._schemaName, true, dataDictionary, languageConnectionContext, compilerContext);
                this._schemaName = this._schema.getSchemaName();
            }
        }

        @Override
        public boolean isBound() {
            return this._descriptor != null;
        }

        @Override
        public int countLeafNodes() {
            return 1;
        }

        @Override
        public OptimizerPlan leftmostLeaf() {
            return this;
        }

        @Override
        public boolean isLeftPrefixOf(OptimizerPlan optimizerPlan) {
            return this.equals(optimizerPlan.leftmostLeaf());
        }

        public String toString() {
            return IdUtil.mkQualifiedName(this._schemaName, this._rowSourceName);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            RowSource rowSource = (RowSource)object;
            if (!this.isBound() || !rowSource.isBound()) {
                return false;
            }
            return this._schemaName.equals(rowSource._schemaName) && this._rowSourceName.equals(rowSource._rowSourceName);
        }
    }

    public static class DeadEnd
    extends OptimizerPlan {
        private String _name;

        public DeadEnd(String string) {
            this._name = string;
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
        }

        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public int countLeafNodes() {
            return 1;
        }

        @Override
        public OptimizerPlan leftmostLeaf() {
            return this;
        }

        @Override
        public boolean isLeftPrefixOf(OptimizerPlan optimizerPlan) {
            return this.equals(optimizerPlan.leftmostLeaf());
        }

        public String toString() {
            return this._name;
        }
    }

    public static final class Join
    extends OptimizerPlan {
        final JoinStrategy strategy;
        final OptimizerPlan leftChild;
        final OptimizerPlan rightChild;
        private boolean _isBound;
        private int _leafNodeCount = 0;

        public Join(JoinStrategy joinStrategy, OptimizerPlan optimizerPlan, OptimizerPlan optimizerPlan2) {
            this.strategy = joinStrategy;
            this.leftChild = optimizerPlan;
            this.rightChild = optimizerPlan2;
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
            if (!(this.rightChild instanceof RowSource)) {
                throw StandardException.newException((String)"42ZCD", (Object[])new Object[0]);
            }
            this.leftChild.bind(dataDictionary, languageConnectionContext, compilerContext);
            this.rightChild.bind(dataDictionary, languageConnectionContext, compilerContext);
            this._isBound = true;
        }

        @Override
        public boolean isBound() {
            return this._isBound;
        }

        @Override
        public int countLeafNodes() {
            if (this._leafNodeCount <= 0) {
                this._leafNodeCount = this.leftChild.countLeafNodes() + this.rightChild.countLeafNodes();
            }
            return this._leafNodeCount;
        }

        @Override
        public OptimizerPlan leftmostLeaf() {
            return this.leftChild.leftmostLeaf();
        }

        @Override
        public boolean isLeftPrefixOf(OptimizerPlan optimizerPlan) {
            int n;
            if (!(optimizerPlan instanceof Join)) {
                return false;
            }
            Join join = (Join)optimizerPlan;
            int n2 = this.countLeafNodes();
            if (n2 > (n = join.countLeafNodes())) {
                return false;
            }
            if (n2 < n) {
                return this.isLeftPrefixOf(join.leftChild);
            }
            return this.equals(join);
        }

        public String toString() {
            return "( " + this.leftChild.toString() + " " + this.strategy.getOperatorSymbol() + " " + this.rightChild.toString() + " )";
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Join)) {
                return false;
            }
            Join join = (Join)object;
            if (!this.strategy.getOperatorSymbol().equals(join.strategy.getOperatorSymbol())) {
                return false;
            }
            return this.leftChild.equals(join.leftChild) && this.rightChild.equals(join.rightChild);
        }
    }
}

