/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.remote;

import ai.digital.deploy.permissions.api.rest.dto.CreateRoleRequest;
import ai.digital.deploy.permissions.api.rest.dto.EditRolePrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.EditRolePrincipalsRequest$;
import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto;
import ai.digital.deploy.permissions.api.rest.dto.UpdateRoleRequest;
import ai.digital.deploy.permissions.api.rest.pagination.Order$;
import ai.digital.deploy.permissions.api.rest.pagination.Paging$;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.RoleServiceClient;
import ai.digital.deploy.permissions.client.configuration.PermissionServiceEntityNotFoundError;
import ai.digital.deploy.permissions.client.remote.ListOfTypeReference;
import ai.digital.deploy.permissions.client.remote.PermissionServiceRemoteClientError;
import ai.digital.deploy.permissions.client.util.SortOrder;
import com.xebialabs.deployit.ServerConfiguration;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"!permission-service"})
@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001B\u001e=\u0001%C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006u\u0002!\ta\u001f\u0005\n\u0003\u0007\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0006\u0001A\u0003%\u0011q\u0001\u0005\n\u00033\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0007\u0001A\u0003%\u0011q\u0001\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\b\u0001A\u0003%\u0011q\u0001\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\t\u0001A\u0003%\u0011q\u0001\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\n\u0001A\u0003%\u0011q\u0001\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\u000b\u0001A\u0003%\u0011q\u0001\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\f\u0001A\u0003%\u0011q\u0001\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\r\u0001A\u0003%\u0011q\u0001\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\u000e\u0001A\u0003%\u0011q\u0001\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\u000f\u0001A\u0003%\u0011q\u0001\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0010\u0001A\u0003%\u0011q\u0001\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0011\u0001A\u0003%\u0011q\u0001\u0005\n\u0003\u000b\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0012\u0001A\u0003%\u0011q\u0001\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0013\u0001A\u0003%\u0011q\u0001\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0014\u0001A\u0003%\u0011q\u0001\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0015\u0001A\u0003%\u0011q\u0001\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0016\u0001A\u0003%\u0011q\u0001\u0005\n\u00033\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0017\u0001A\u0003%\u0011q\u0001\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003\u000bA\u0001\"a\u0018\u0001A\u0003%\u0011q\u0001\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\t\t\n\u0001C!\u0003'Cq!a-\u0001\t\u0003\n)\fC\u0004\u0002<\u0002!\t%!0\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9\u00111\u001d\u0001\u0005B\u0005\u0015\bbBAI\u0001\u0011\u0005\u0013q\u001d\u0005\b\u0003w\u0003A\u0011IAv\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqA!\u0003\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u0010\u0001!\tE!\u0005\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a!9!1\u0005\u0001\u0005B\t\u0015\u0002b\u0002B\u0012\u0001\u0011\u0005#1\u0006\u0005\b\u0005/\u0002A\u0011\u0002B-\u0011\u001d\u0011i\u0006\u0001C!\u0005?BqA!\u001b\u0001\t\u0003\u0012Y\u0007C\u0004\u0003x\u0001!\tE!\u001f\u0003/I+Wn\u001c;f%>dWmU3sm&\u001cWm\u00117jK:$(BA\u001f?\u0003\u0019\u0011X-\\8uK*\u0011q\bQ\u0001\u0007G2LWM\u001c;\u000b\u0005\u0005\u0013\u0015a\u00039fe6L7o]5p]NT!a\u0011#\u0002\r\u0011,\u0007\u000f\\8z\u0015\t)e)A\u0004eS\u001eLG/\u00197\u000b\u0003\u001d\u000b!!Y5\u0004\u0001M!\u0001A\u0013)U!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0019\te.\u001f*fMB\u0011\u0011KU\u0007\u0002}%\u00111K\u0010\u0002\u0012%>dWmU3sm&\u001cWm\u00117jK:$\bCA+[\u001b\u00051&BA,Y\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0016\u0001C4sSjTH.\u001a3\n\u0005m3&a\u0002'pO\u001eLgnZ\u0001\re\u0016\u001cH\u000fV3na2\fG/\u001a\t\u0003=\u001al\u0011a\u0018\u0006\u0003\u007f\u0001T!!\u00192\u0002\u0007],'M\u0003\u0002dI\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001f\u0003\ry'oZ\u0005\u0003O~\u0013ABU3tiR+W\u000e\u001d7bi\u0016D#!A5\u0011\u0005)\fX\"A6\u000b\u00051l\u0017AC1o]>$\u0018\r^5p]*\u0011an\\\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0001(-A\u0003cK\u0006t7/\u0003\u0002sW\nI\u0011)\u001e;po&\u0014X\r\u001a\u0015\u0005\u0003Q<\b\u0010\u0005\u0002kk&\u0011ao\u001b\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f\u0013!_\u0001\u001ea\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,'+Z:u)\u0016l\u0007\u000f\\1uK\u00061A(\u001b8jiz\"\"\u0001 @\u0011\u0005u\u0004Q\"\u0001\u001f\t\u000bq\u0013\u0001\u0019A/)\u0005yL\u0007\u0006\u0002@uob\fA\u0003]3s[&\u001c8/[8o'\u0016\u0014h/[2f+JdWCAA\u0004!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tA\u0001\\1oO*\u0011\u0011\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0005-!AB*ue&tw-A\u000bqKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016,&\u000f\u001c\u0011\u0002\u0017I|G.\u001a\"bg\u0016,&\u000f\\\u0001\re>dWMQ1tKV\u0013H\u000eI\u0001\u001de\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8t\u0005\u0006\u001cX-\u0016:m\u0003u\u0011XMZ3sK:\u001cW\r\u001a)fe6L7o]5p]N\u0014\u0015m]3Ve2\u0004\u0013aC4fi\u0006cGNU8mKN\fAbZ3u\u00032d'k\u001c7fg\u0002\nQb\u0019:fCR,'k\u001c7f+Jd\u0017AD2sK\u0006$XMU8mKV\u0013H\u000eI\u0001\u0016GJ,\u0017\r^3PeV\u0003H-\u0019;f%>dW-\u0016:m\u0003Y\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016\u0014v\u000e\\3Ve2\u0004\u0013!D;qI\u0006$XMU8mKV\u0013H.\u0001\bva\u0012\fG/\u001a*pY\u0016,&\u000f\u001c\u0011\u0002\u001bI,g.Y7f%>dW-\u0016:m\u00039\u0011XM\\1nKJ{G.Z+sY\u0002\nQ\u0002Z3mKR,'k\u001c7f+Jd\u0017A\u00043fY\u0016$XMU8mKV\u0013H\u000eI\u0001\u0012I\u0016dW\r^3S_2,')_%e+Jd\u0017A\u00053fY\u0016$XMU8mK\nK\u0018\nZ+sY\u0002\n1B]3bIJ{G.Z+sY\u0006a!/Z1e%>dW-\u0016:mA\u0005y!/Z1e%>dWMQ=JIV\u0013H.\u0001\tsK\u0006$'k\u001c7f\u0005fLE-\u0016:mA\u0005a!/Z1e%>dWm]+sY\u0006i!/Z1e%>dWm]+sY\u0002\nQbY8v]R\u0014v\u000e\\3t+Jd\u0017AD2pk:$(k\u001c7fgV\u0013H\u000eI\u0001\u0018e\u0016\fGMU8mKN4uN\u001d*pY\u0016\u0004\u0016\r\u001e;fe:\f\u0001D]3bIJ{G.Z:G_J\u0014v\u000e\\3QCR$XM\u001d8!\u0003Y\u0019'/Z1uKJ{G.\u001a)sS:\u001c\u0017\u000e]1m+Jd\u0017aF2sK\u0006$XMU8mKB\u0013\u0018N\\2ja\u0006dWK\u001d7!\u0003Y)\b\u000fZ1uKJ{G.\u001a)sS:\u001c\u0017\u000e]1m+Jd\u0017aF;qI\u0006$XMU8mKB\u0013\u0018N\\2ja\u0006dWK\u001d7!\u0003Q!W\r\\3uK\u0006cGNU8mKJ+gm]+sY\u0006)B-\u001a7fi\u0016\fE\u000e\u001c*pY\u0016\u0014VMZ:Ve2\u0004\u0013!\u00053fY\u0016$X-\u00117m%>dWm]+sY\u0006\u0011B-\u001a7fi\u0016\fE\u000e\u001c*pY\u0016\u001cXK\u001d7!\u0003\u00199W\r^!mYV\u0011\u0011Q\r\t\u0007\u0003O\n9(! \u000f\t\u0005%\u00141\u000f\b\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e%\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0015bAA;\u0019\u00069\u0001/Y2lC\u001e,\u0017\u0002BA=\u0003w\u0012A\u0001T5ti*\u0019\u0011Q\u000f'\u0011\t\u0005}\u0014QR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006\u0019A\r^8\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0005e\u0016\u001cHOC\u0002\u0002\f\u0002\u000b1!\u00199j\u0013\u0011\ty)!!\u0003\u000fI{G.\u001a#u_\u000611M]3bi\u0016$b!!&\u0002\u001c\u00065\u0006\u0003BA@\u0003/KA!!'\u0002\u0002\n)\"k\u001c7f/&$\b\u000e\u0015:j]\u000eL\u0007/\u00197t\tR|\u0007bBAOU\u0001\u0007\u0011qT\u0001\u0005]\u0006lW\r\u0005\u0003\u0002\"\u0006%f\u0002BAR\u0003K\u00032!a\u001bM\u0013\r\t9\u000bT\u0001\u0007!J,G-\u001a4\n\t\u0005U\u00111\u0016\u0006\u0004\u0003Oc\u0005bBAXU\u0001\u0007\u0011\u0011W\u0001\u000baJLgnY5qC2\u001c\bCBA4\u0003o\ny*\u0001\bde\u0016\fG/Z(s+B$\u0017\r^3\u0015\t\u0005u\u0014q\u0017\u0005\b\u0003s[\u0003\u0019AA?\u0003\u0011\u0011x\u000e\\3\u0002\rU\u0004H-\u0019;f))\t)*a0\u0002D\u0006\u001d\u0017\u0011\u001b\u0005\b\u0003\u0003d\u0003\u0019AAP\u0003Ay'/[4j]\u0006d'k\u001c7f\u001d\u0006lW\rC\u0004\u0002F2\u0002\r!a(\u0002\u001fU\u0004H-\u0019;fIJ{G.\u001a(b[\u0016Dq!!3-\u0001\u0004\tY-\u0001\nqe&t7-\u001b9bYN$vn\u0011:fCR,\u0007CBAQ\u0003\u001b\fy*\u0003\u0003\u0002P\u0006-&aA*fi\"9\u00111\u001b\u0017A\u0002\u0005-\u0017A\u00059sS:\u001c\u0017\u000e]1mgR{G)\u001a7fi\u0016\f1C]3n_Z,\u0017\t\u001c7SK\u001a,'/\u001a8dKN$B!!7\u0002`B\u00191*a7\n\u0007\u0005uGJ\u0001\u0003V]&$\bbBAq[\u0001\u0007\u0011qT\u0001\te>dWMT1nK\u0006I!/Z7pm\u0016\fE\u000e\u001c\u000b\u0003\u00033$B!! \u0002j\"9\u0011QT\u0018A\u0002\u0005}ECBA?\u0003[\fi\u0010C\u0004\u0002pB\u0002\r!!=\u0002\u0005%$\u0007\u0003BAz\u0003sl!!!>\u000b\t\u0005]\u0018qB\u0001\u0005kRLG.\u0003\u0003\u0002|\u0006U(\u0001B+V\u0013\u0012Cq!!91\u0001\u0004\ty*\u0001\u0004sK:\fW.\u001a\u000b\u0007\u0003{\u0012\u0019A!\u0002\t\u000f\u0005u\u0015\u00071\u0001\u0002 \"9!qA\u0019A\u0002\u0005}\u0015a\u00028fo:\u000bW.Z\u0001\u0007I\u0016dW\r^3\u0015\t\u0005e'Q\u0002\u0005\b\u0003C\u0014\u0004\u0019AAP\u0003)!W\r\\3uK\nK\u0018\n\u001a\u000b\u0005\u00033\u0014\u0019\u0002C\u0004\u0003\u0016M\u0002\r!a(\u0002\rI|G.Z%e\u0003!\u0011X-\u00193Cs&#G\u0003\u0002B\u000e\u0005C\u0001Ra\u0013B\u000f\u0003+K1Aa\bM\u0005\u0019y\u0005\u000f^5p]\"9!Q\u0003\u001bA\u0002\u0005}\u0015\u0001\u0002:fC\u0012$BAa\n\u0003*A)1J!\b\u0002~!9\u0011\u0011]\u001bA\u0002\u0005}E\u0003\u0004B\u0017\u0005g\u00119D!\u0011\u0003F\tM\u0003#B)\u00030\u0005u\u0014b\u0001B\u0019}\t\t\u0002+Y4j]\u0006$X\r\u001a*fgB|gn]3\t\u000f\tUb\u00071\u0001\u0002 \u0006Ya.Y7f!\u0006$H/\u001a:o\u0011\u001d\u0011ID\u000ea\u0001\u0005w\tA\u0001]1hKB\u00191J!\u0010\n\u0007\t}BJA\u0002J]RDqAa\u00117\u0001\u0004\u0011Y$\u0001\u0003tSj,\u0007b\u0002B$m\u0001\u0007!\u0011J\u0001\u0006_J$WM\u001d\t\u0005\u0005\u0017\u0012y%\u0004\u0002\u0003N)\u0019\u0011q\u001f \n\t\tE#Q\n\u0002\n'>\u0014Ho\u0014:eKJDqA!\u00167\u0001\u0004\ty*A\u0003gS\u0016dG-\u0001\nsK\u0006$'k\u001c7f!JLgnY5qC2\u001cH\u0003BAY\u00057Bq!!98\u0001\u0004\ty*\u0001\u0006s_2,W\t_5tiN$BA!\u0019\u0003hA\u00191Ja\u0019\n\u0007\t\u0015DJA\u0004C_>dW-\u00198\t\u000f\u0005\u0005\b\b1\u0001\u0002 \u0006Q1m\\;oiJ{G.Z:\u0015\t\t5$1\u000f\t\u0004\u0017\n=\u0014b\u0001B9\u0019\n!Aj\u001c8h\u0011\u001d\u0011)(\u000fa\u0001\u0003?\u000bqB]8mK:\u000bW.\u001a)biR,'O\\\u0001\u0012e\u0016\fGMQ=S_2,\u0007+\u0019;uKJtG\u0003BA3\u0005wBqA!\u000e;\u0001\u0004\ty\nK\u0002\u0001\u0005\u007f\u0002BA!!\u0003\b6\u0011!1\u0011\u0006\u0004\u0005\u000b\u0013\u0017AC:uKJ,w\u000e^=qK&!!\u0011\u0012BB\u0005%\u0019u.\u001c9p]\u0016tG\u000f\u000b\u0004\u0001\u0005\u001b;(1\u0014\t\u0005\u0005\u001f\u00139*\u0004\u0002\u0003\u0012*\u0019ANa%\u000b\u0007\tU%-A\u0004d_:$X\r\u001f;\n\t\te%\u0011\u0013\u0002\b!J|g-\u001b7fY\t\u0011i*\t\u0002\u0003 \u0006\u0019\u0012\u0005]3s[&\u001c8/[8o[M,'O^5dK\u0002")
public class RemoteRoleServiceClient
implements RoleServiceClient,
Logging {
    @Autowired
    @Qualifier(value="permissionServiceRestTemplate")
    private final RestTemplate restTemplate;
    private final String permissionServiceUrl;
    private final String roleBaseUrl;
    private final String referencedPermissionsBaseUrl;
    private final String getAllRoles;
    private final String createRoleUrl;
    private final String createOrUpdateRoleUrl;
    private final String updateRoleUrl;
    private final String renameRoleUrl;
    private final String deleteRoleUrl;
    private final String deleteRoleByIdUrl;
    private final String readRoleUrl;
    private final String readRoleByIdUrl;
    private final String readRolesUrl;
    private final String countRolesUrl;
    private final String readRolesForRolePattern;
    private final String createRolePrincipalUrl;
    private final String updateRolePrincipalUrl;
    private final String deleteAllRoleRefsUrl;
    private final String deleteAllRolesUrl;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RemoteRoleServiceClient remoteRoleServiceClient = this;
        synchronized (remoteRoleServiceClient) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private String permissionServiceUrl() {
        return this.permissionServiceUrl;
    }

    private String roleBaseUrl() {
        return this.roleBaseUrl;
    }

    private String referencedPermissionsBaseUrl() {
        return this.referencedPermissionsBaseUrl;
    }

    private String getAllRoles() {
        return this.getAllRoles;
    }

    private String createRoleUrl() {
        return this.createRoleUrl;
    }

    private String createOrUpdateRoleUrl() {
        return this.createOrUpdateRoleUrl;
    }

    private String updateRoleUrl() {
        return this.updateRoleUrl;
    }

    private String renameRoleUrl() {
        return this.renameRoleUrl;
    }

    private String deleteRoleUrl() {
        return this.deleteRoleUrl;
    }

    private String deleteRoleByIdUrl() {
        return this.deleteRoleByIdUrl;
    }

    private String readRoleUrl() {
        return this.readRoleUrl;
    }

    private String readRoleByIdUrl() {
        return this.readRoleByIdUrl;
    }

    private String readRolesUrl() {
        return this.readRolesUrl;
    }

    private String countRolesUrl() {
        return this.countRolesUrl;
    }

    private String readRolesForRolePattern() {
        return this.readRolesForRolePattern;
    }

    private String createRolePrincipalUrl() {
        return this.createRolePrincipalUrl;
    }

    private String updateRolePrincipalUrl() {
        return this.updateRolePrincipalUrl;
    }

    private String deleteAllRoleRefsUrl() {
        return this.deleteAllRoleRefsUrl;
    }

    private String deleteAllRolesUrl() {
        return this.deleteAllRolesUrl;
    }

    @Override
    public List<RoleDto> getAll() {
        return (List)this.restTemplate.exchange(this.getAllRoles(), HttpMethod.GET, null, new ListOfTypeReference(), new Object[0]).getBody();
    }

    @Override
    public RoleWithPrincipalsDto create(String name, List<String> principals) {
        RoleDto role = this.create(name);
        if (principals.nonEmpty()) {
            return (RoleWithPrincipalsDto)this.restTemplate.exchange(this.createRolePrincipalUrl(), HttpMethod.POST, new HttpEntity((Object)CollectionConverters$.MODULE$.SeqHasAsJava(principals).asJava()), RoleWithPrincipalsDto.class, new Object[]{name}).getBody();
        }
        List<String> rolePrincipals = this.readRolePrincipals(name);
        return new RoleWithPrincipalsDto(role, rolePrincipals);
    }

    @Override
    public RoleDto createOrUpdate(RoleDto role) {
        UpdateRoleRequest saveRoleRequest = new UpdateRoleRequest();
        saveRoleRequest.setId(role.id().toString());
        saveRoleRequest.setName(role.name());
        return (RoleDto)this.restTemplate.exchange(this.createOrUpdateRoleUrl(), HttpMethod.POST, new HttpEntity((Object)saveRoleRequest), RoleDto.class, new Object[0]).getBody();
    }

    @Override
    public RoleWithPrincipalsDto update(String originalRoleName, String updatedRoleName, Set<String> principalsToCreate, Set<String> principalsToDelete) {
        EditRolePrincipalsRequest request = EditRolePrincipalsRequest$.MODULE$.apply(principalsToDelete.toList(), principalsToCreate.toList());
        RoleWithPrincipalsDto result = (RoleWithPrincipalsDto)this.restTemplate.exchange(this.updateRolePrincipalUrl(), HttpMethod.PATCH, new HttpEntity((Object)request), RoleWithPrincipalsDto.class, new Object[]{originalRoleName}).getBody();
        Option$.MODULE$.apply((Object)result.role()).orElse((Function0 & Serializable)() -> {
            throw new PermissionServiceRemoteClientError("Role with name '" + originalRoleName + "' doesn't exists - cannot execute update.");
        });
        Option$.MODULE$.apply((Object)result.role().id()).orElse((Function0 & Serializable)() -> {
            throw new PermissionServiceRemoteClientError("Role with name '" + originalRoleName + "' has no UUID - cannot execute update.");
        });
        String string = originalRoleName;
        String string2 = updatedRoleName;
        if (string == null ? string2 != null : !string.equals(string2)) {
            UpdateRoleRequest updateRoleRequest = new UpdateRoleRequest();
            updateRoleRequest.setId(result.role().id().toString());
            updateRoleRequest.setName(updatedRoleName);
            RoleDto roleDto = (RoleDto)this.restTemplate.exchange(this.roleBaseUrl(), HttpMethod.PUT, new HttpEntity((Object)updateRoleRequest), RoleDto.class, new Object[0]).getBody();
            return new RoleWithPrincipalsDto(roleDto, result.principals());
        }
        return result;
    }

    @Override
    public void removeAllReferences(String roleName) {
        this.restTemplate.delete(this.deleteAllRoleRefsUrl(), new Object[]{roleName});
    }

    @Override
    public void removeAll() {
        this.restTemplate.delete(this.deleteAllRolesUrl(), new Object[0]);
    }

    @Override
    public RoleDto create(String name) {
        CreateRoleRequest roleRequest = new CreateRoleRequest();
        roleRequest.setName(name);
        return (RoleDto)this.restTemplate.postForObject(this.createRoleUrl(), (Object)roleRequest, RoleDto.class, new Object[0]);
    }

    @Override
    public RoleDto update(UUID id, String roleName) {
        UpdateRoleRequest updateRequest = new UpdateRoleRequest();
        updateRequest.id_$eq(id.toString());
        updateRequest.name_$eq(roleName);
        return (RoleDto)this.restTemplate.postForObject(this.updateRoleUrl(), (Object)updateRequest, RoleDto.class, new Object[0]);
    }

    @Override
    public RoleDto rename(String name, String newName) {
        URI uri = UriComponentsBuilder.fromUriString((String)this.renameRoleUrl()).build(new Object[]{name});
        CreateRoleRequest roleRequest = new CreateRoleRequest();
        roleRequest.setName(newName);
        return (RoleDto)this.restTemplate.exchange(uri, HttpMethod.PUT, new HttpEntity((Object)roleRequest), RoleDto.class).getBody();
    }

    @Override
    public void delete(String roleName) {
        this.restTemplate.delete(this.deleteRoleUrl(), new Object[]{roleName});
    }

    @Override
    public void deleteById(String roleId) {
        this.restTemplate.delete(this.deleteRoleByIdUrl(), new Object[]{roleId});
    }

    @Override
    public Option<RoleWithPrincipalsDto> readById(String roleId) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (RoleWithPrincipalsDto)$this.restTemplate.getForObject(this.readRoleByIdUrl(), RoleWithPrincipalsDto.class, new Object[]{roleId}));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            RoleWithPrincipalsDto value = (RoleWithPrincipalsDto)success.value();
            return Option$.MODULE$.apply((Object)value);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof PermissionServiceEntityNotFoundError) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Throwable exception = failure.exception();
            throw exception;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Option<RoleDto> read(String roleName) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (RoleDto)$this.restTemplate.getForObject(this.readRoleUrl(), RoleDto.class, new Object[]{roleName}));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            RoleDto value = (RoleDto)success.value();
            return Option$.MODULE$.apply((Object)value);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof PermissionServiceEntityNotFoundError) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Throwable exception = failure.exception();
            throw exception;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public PaginatedResponse<RoleDto> read(String namePattern, int page, int size, SortOrder order, String field) {
        URI uri = UriComponentsBuilder.fromUriString((String)this.readRolesUrl()).queryParam("namePattern", new Object[]{namePattern}).queryParam(Paging$.MODULE$.PAGE_PARAMETER(), new Object[]{BoxesRunTime.boxToInteger((int)page)}).queryParam(Paging$.MODULE$.SIZE_PARAMETER(), new Object[]{BoxesRunTime.boxToInteger((int)size)}).queryParam(Order$.MODULE$.ORDER_PARAMETER(), new Object[]{field + ":" + order.value()}).build().toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, null, RoleDto[].class);
        HttpHeaders headers = response.getHeaders();
        return new PaginatedResponse<RoleDto>(Predef$.MODULE$.wrapRefArray((Object[])response.getBody()).toList(), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_TOTAL_COUNT_HEADER()))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_PAGE()))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_SIZE()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_HAS_NEXT_PAGE_HEADER()))));
    }

    private List<String> readRolePrincipals(String roleName) {
        ParameterizedTypeReference<List<String>> responseType = new ParameterizedTypeReference<List<String>>(null){};
        URI readPrincipalsUrl = UriComponentsBuilder.fromUriString((String)(this.permissionServiceUrl() + "/v1/roles/{roleName}/principals")).build(new Object[]{roleName});
        return (List)this.restTemplate.exchange(readPrincipalsUrl, HttpMethod.GET, null, (ParameterizedTypeReference)responseType).getBody();
    }

    @Override
    public boolean roleExists(String roleName) {
        return this.read(roleName).isDefined();
    }

    @Override
    public long countRoles(String roleNamePattern) {
        URI uri = UriComponentsBuilder.fromUriString((String)this.countRolesUrl()).queryParam("namePattern", new Object[]{roleNamePattern}).build().toUri();
        return BoxesRunTime.unboxToLong((Object)this.restTemplate.exchange(uri, HttpMethod.GET, null, Long.TYPE).getBody());
    }

    @Override
    public List<RoleDto> readByRolePattern(String namePattern) {
        ParameterizedTypeReference<List<RoleDto>> responseType = new ParameterizedTypeReference<List<RoleDto>>(null){};
        URI uri = UriComponentsBuilder.fromUriString((String)this.readRolesForRolePattern()).queryParam("namePattern", new Object[]{namePattern}).build().toUri();
        return (List)this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType).getBody();
    }

    public RemoteRoleServiceClient(@Autowired @Qualifier(value="permissionServiceRestTemplate") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        Logging.$init$((Logging)this);
        this.permissionServiceUrl = ServerConfiguration.getInstance().getExternalPermissionServiceUri();
        this.roleBaseUrl = this.permissionServiceUrl() + "/v1/roles";
        this.referencedPermissionsBaseUrl = this.permissionServiceUrl() + "/v1/permissions/reference";
        this.getAllRoles = this.permissionServiceUrl() + "/v1/roles/all";
        this.createRoleUrl = this.roleBaseUrl();
        this.createOrUpdateRoleUrl = this.roleBaseUrl() + "/save";
        this.updateRoleUrl = this.roleBaseUrl();
        this.renameRoleUrl = this.roleBaseUrl() + "/{name}/rename";
        this.deleteRoleUrl = this.roleBaseUrl() + "/{name}";
        this.deleteRoleByIdUrl = this.roleBaseUrl() + "/id/{roleUuid}";
        this.readRoleUrl = this.roleBaseUrl() + "/{name}";
        this.readRoleByIdUrl = this.roleBaseUrl() + "/id/{roleUuid}";
        this.readRolesUrl = this.roleBaseUrl();
        this.countRolesUrl = this.roleBaseUrl() + "/count";
        this.readRolesForRolePattern = this.roleBaseUrl() + "/filter";
        this.createRolePrincipalUrl = this.permissionServiceUrl() + "/v1/roles/{roleName}/principals";
        this.updateRolePrincipalUrl = this.permissionServiceUrl() + "/v2/roles/{roleName}/principals";
        this.deleteAllRoleRefsUrl = this.roleBaseUrl() + "/{name}/all";
        this.deleteAllRolesUrl = this.roleBaseUrl() + "/all";
    }
}

