/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.diagnostics;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class GitUriFailureAnalyzer
extends AbstractFailureAnalyzer<IllegalStateException> {
    public static final String DESCRIPTION = "Invalid config server configuration.";
    public static final String ACTION = "If you are using the git profile, you need to set a Git URI in your configuration.  If you have set spring.cloud.config.server.bootstrap=true, you need to use a composite configuration.";

    protected FailureAnalysis analyze(Throwable rootFailure, IllegalStateException cause) {
        if ("You need to configure a uri for the git repository.".equalsIgnoreCase(cause.getMessage())) {
            return new FailureAnalysis(DESCRIPTION, ACTION, (Throwable)cause);
        }
        return null;
    }
}

