/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.auth;

import com.hierynomus.asn1.types.primitive.ASN1ObjectIdentifier;
import com.hierynomus.msdtyp.FileTime;
import com.hierynomus.ntlm.NtlmConfig;
import com.hierynomus.ntlm.NtlmException;
import com.hierynomus.ntlm.av.AvId;
import com.hierynomus.ntlm.av.AvPair;
import com.hierynomus.ntlm.av.AvPairFlags;
import com.hierynomus.ntlm.av.AvPairString;
import com.hierynomus.ntlm.av.AvPairTimestamp;
import com.hierynomus.ntlm.functions.ComputedNtlmV2Response;
import com.hierynomus.ntlm.functions.NtlmFunctions;
import com.hierynomus.ntlm.functions.NtlmV2Functions;
import com.hierynomus.ntlm.messages.NtlmAuthenticate;
import com.hierynomus.ntlm.messages.NtlmChallenge;
import com.hierynomus.ntlm.messages.NtlmNegotiate;
import com.hierynomus.ntlm.messages.NtlmNegotiateFlag;
import com.hierynomus.ntlm.messages.TargetInfo;
import com.hierynomus.protocol.commons.ByteArrayUtils;
import com.hierynomus.protocol.commons.Factory;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.security.SecurityProvider;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticateResponse;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.auth.Authenticator;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.connection.ConnectionContext;
import com.hierynomus.spnego.NegTokenInit;
import com.hierynomus.spnego.NegTokenTarg;
import com.hierynomus.spnego.SpnegoException;
import com.hierynomus.spnego.SpnegoToken;
import com.hierynomus.utils.Strings;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(NtlmAuthenticator.class);
    private static final ASN1ObjectIdentifier NTLMSSP = new ASN1ObjectIdentifier("1.3.6.1.4.1.311.2.2.10");
    private SecurityProvider securityProvider;
    private Random random;
    private NtlmV2Functions functions;
    private NtlmConfig config;
    private State state;
    private Set<NtlmNegotiateFlag> negotiateFlags;
    private byte[] negotiateMessage;

    @Override
    public AuthenticateResponse authenticate(AuthenticationContext context, byte[] gssToken, ConnectionContext connectionContext) throws IOException {
        try {
            if (this.state == State.COMPLETE) {
                return null;
            }
            if (this.state == State.NEGOTIATE) {
                logger.debug("Initialized Authentication of {} using NTLM", (Object)context.getUsername());
                this.state = State.AUTHENTICATE;
                return this.doNegotiate(context, gssToken);
            }
            logger.debug("Received token: {}", (Object)ByteArrayUtils.printHex(gssToken));
            NegTokenTarg negTokenTarg = new NegTokenTarg().read(gssToken);
            NtlmChallenge serverNtlmChallenge = new NtlmChallenge();
            try {
                serverNtlmChallenge.read(new Buffer.PlainBuffer(negTokenTarg.getResponseToken(), Endian.LE));
            }
            catch (Buffer.BufferException e) {
                throw new IOException(e);
            }
            logger.trace("Received NTLM challenge: {}", (Object)serverNtlmChallenge);
            logger.debug("Received NTLM challenge from: {}", (Object)serverNtlmChallenge.getTargetName());
            this.negotiateFlags.removeIf(ntlmNegotiateFlag -> !serverNtlmChallenge.getNegotiateFlags().contains(ntlmNegotiateFlag));
            if (!this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_128)) {
                throw new NtlmException("Server does not support 128-bit encryption");
            }
            AuthenticateResponse resp = this.doAuthenticate(context, serverNtlmChallenge, negTokenTarg.getResponseToken());
            this.state = State.COMPLETE;
            return resp;
        }
        catch (SpnegoException spne) {
            throw new SMBRuntimeException(spne);
        }
    }

    private AuthenticateResponse doNegotiate(AuthenticationContext context, byte[] gssToken) throws SpnegoException {
        AuthenticateResponse response = new AuthenticateResponse();
        this.negotiateFlags = EnumSet.of(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_128, NtlmNegotiateFlag.NTLMSSP_REQUEST_TARGET, NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY);
        if (!this.config.isOmitVersion() && this.config.getWindowsVersion() != null) {
            this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_VERSION);
        }
        if (!context.isAnonymous()) {
            this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_SIGN);
            this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_ALWAYS_SIGN);
            this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_KEY_EXCH);
        } else if (context.isGuest()) {
            this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_KEY_EXCH);
        } else {
            this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_ANONYMOUS);
        }
        if (!this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_VERSION)) {
            if (Strings.isNotBlank(context.getDomain())) {
                this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED);
            }
            if (Strings.isNotBlank(this.config.getWorkstationName())) {
                this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED);
            }
        }
        NtlmNegotiate negotiateMessage = new NtlmNegotiate(this.negotiateFlags, context.getDomain(), this.config.getWorkstationName(), this.config.getWindowsVersion(), this.config.isOmitVersion());
        logger.trace("Sending NTLM negotiate message: {}", (Object)this.negotiateMessage);
        response.setNegToken(this.negTokenInit(negotiateMessage));
        response.setNegotiateFlags(this.negotiateFlags);
        return response;
    }

    private AuthenticateResponse doAuthenticate(AuthenticationContext context, NtlmChallenge serverNtlmChallenge, byte[] ntlmChallengeBytes) throws SpnegoException {
        AvPairFlags pair;
        byte[] encryptedRandomSessionKey;
        byte[] exportedSessionKey;
        AuthenticateResponse response = new AuthenticateResponse();
        response.setWindowsVersion(serverNtlmChallenge.getVersion());
        if (serverNtlmChallenge.getTargetInfo() != null && serverNtlmChallenge.getTargetInfo().hasAvPair(AvId.MsvAvNbComputerName)) {
            response.setNetBiosName((String)((AvPair)serverNtlmChallenge.getTargetInfo().getAvPair(AvId.MsvAvNbComputerName)).getValue());
        }
        if (context.isAnonymous()) {
            NtlmAuthenticate msg = new NtlmAuthenticate(null, null, context.getUsername(), context.getDomain(), this.config.getWorkstationName(), null, this.negotiateFlags, this.config.getWindowsVersion());
            response.setNegToken(this.negTokenTarg(msg));
            return response;
        }
        this.negotiateFlags.add(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_TARGET_INFO);
        TargetInfo clientTargetInfo = this.createClientTargetInfo(serverNtlmChallenge);
        long time = FileTime.now().getWindowsTimeStamp();
        if (clientTargetInfo != null && clientTargetInfo.hasAvPair(AvId.MsvAvTimestamp)) {
            time = ((FileTime)((AvPairTimestamp)clientTargetInfo.getAvPair(AvId.MsvAvTimestamp)).getValue()).getWindowsTimeStamp();
        }
        ComputedNtlmV2Response computedNtlmV2Response = this.functions.computeResponse(context.getUsername(), context.getDomain(), context.getPassword(), serverNtlmChallenge, time, clientTargetInfo);
        byte[] sessionBaseKey = computedNtlmV2Response.getSessionBaseKey();
        byte[] ntResponse = computedNtlmV2Response.getNtResponse();
        byte[] lmResponse = new byte[]{};
        byte[] keyExchangeKey = this.functions.kxKey(sessionBaseKey, computedNtlmV2Response.getLmResponse(), serverNtlmChallenge.getServerChallenge());
        EnumSet<NtlmNegotiateFlag> serverFlags = serverNtlmChallenge.getNegotiateFlags();
        if (serverFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_KEY_EXCH) && (serverFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_SEAL) || serverFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_SIGN) || serverFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_ALWAYS_SIGN))) {
            exportedSessionKey = new byte[16];
            this.random.nextBytes(exportedSessionKey);
            encryptedRandomSessionKey = NtlmFunctions.rc4k(this.securityProvider, keyExchangeKey, exportedSessionKey);
        } else {
            encryptedRandomSessionKey = exportedSessionKey = keyExchangeKey;
        }
        NtlmAuthenticate msg = new NtlmAuthenticate(lmResponse, ntResponse, context.getUsername(), context.getDomain(), this.config.getWorkstationName(), encryptedRandomSessionKey, serverFlags, this.config.getWindowsVersion());
        AvPairFlags avPairFlags = pair = clientTargetInfo != null ? (AvPairFlags)clientTargetInfo.getAvPair(AvId.MsvAvFlags) : null;
        if (pair != null && ((Long)pair.getValue() & 2L) > 0L) {
            msg.setMic(new byte[16]);
            Buffer.PlainBuffer micBuffer = new Buffer.PlainBuffer(Endian.LE);
            msg.write(micBuffer);
            byte[] mic = NtlmFunctions.hmac_md5(this.securityProvider, exportedSessionKey, this.negotiateMessage, ntlmChallengeBytes, micBuffer.getCompactData());
            msg.setMic(mic);
        }
        response.setSessionKey(exportedSessionKey);
        logger.trace("Sending NTLM authenticate message: {}", (Object)msg);
        response.setNegToken(this.negTokenTarg(msg));
        response.setNegotiateFlags(this.negotiateFlags);
        return response;
    }

    private TargetInfo createClientTargetInfo(NtlmChallenge serverNtlmChallenge) {
        if (serverNtlmChallenge.getTargetInfo() == null) {
            return null;
        }
        TargetInfo clientTargetInfo = serverNtlmChallenge.getTargetInfo().copy();
        if (this.config.isIntegrityEnabled() && serverNtlmChallenge.getTargetInfo().hasAvPair(AvId.MsvAvTimestamp)) {
            long flags = 2L;
            if (clientTargetInfo.hasAvPair(AvId.MsvAvFlags)) {
                flags |= ((Long)((AvPair)clientTargetInfo.getAvPair(AvId.MsvAvFlags)).getValue()).longValue();
            }
            clientTargetInfo.putAvPair(new AvPairFlags(flags));
        }
        if (serverNtlmChallenge.getNegotiateFlags().contains(NtlmNegotiateFlag.NTLMSSP_REQUEST_TARGET)) {
            AvPairString dnsComputerName = (AvPairString)clientTargetInfo.getAvPair(AvId.MsvAvDnsComputerName);
            if (dnsComputerName != null) {
                String targetName = String.format("cifs/%s", dnsComputerName.getValue());
                clientTargetInfo.putAvPair(new AvPairString(AvId.MsvAvTargetName, targetName));
            }
        } else {
            clientTargetInfo.putAvPair(new AvPairString(AvId.MsvAvTargetName, ""));
        }
        return clientTargetInfo;
    }

    private SpnegoToken negTokenInit(NtlmNegotiate ntlmNegotiate) throws SpnegoException {
        NegTokenInit negTokenInit = new NegTokenInit();
        negTokenInit.addSupportedMech(NTLMSSP);
        Buffer.PlainBuffer ntlmBuffer = new Buffer.PlainBuffer(Endian.LE);
        ntlmNegotiate.write(ntlmBuffer);
        this.negotiateMessage = ntlmBuffer.getCompactData();
        negTokenInit.setMechToken(this.negotiateMessage);
        return negTokenInit;
    }

    private SpnegoToken negTokenTarg(NtlmAuthenticate resp) throws SpnegoException {
        NegTokenTarg targ = new NegTokenTarg();
        Buffer.PlainBuffer ntlmBuffer = new Buffer.PlainBuffer(Endian.LE);
        resp.write(ntlmBuffer);
        targ.setResponseToken(ntlmBuffer.getCompactData());
        return targ;
    }

    @Override
    public void init(SmbConfig config) {
        this.securityProvider = config.getSecurityProvider();
        this.random = config.getRandomProvider();
        this.config = config.getNtlmConfig();
        this.state = State.NEGOTIATE;
        this.negotiateFlags = new HashSet<NtlmNegotiateFlag>();
        this.functions = new NtlmV2Functions(this.random, this.securityProvider);
    }

    @Override
    public boolean supports(AuthenticationContext context) {
        return context.getClass().equals(AuthenticationContext.class);
    }

    public static class Factory
    implements Factory.Named<Authenticator> {
        @Override
        public String getName() {
            return NTLMSSP.getValue();
        }

        @Override
        public NtlmAuthenticator create() {
            return new NtlmAuthenticator();
        }
    }

    static enum State {
        NEGOTIATE,
        AUTHENTICATE,
        COMPLETE;

    }
}

