/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.types;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.infinispan.protostream.annotations.impl.types.DocumentationExtractor;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XConstructor;
import org.infinispan.protostream.annotations.impl.types.XEnumConstant;
import org.infinispan.protostream.annotations.impl.types.XField;
import org.infinispan.protostream.annotations.impl.types.XMethod;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.impl.Log;

public final class ReflectionTypeFactory
implements XTypeFactory {
    private static final Log log = Log.LogFactory.getLog(ReflectionTypeFactory.class);
    private final Map<Class<?>, XClass> classCache = new HashMap();

    @Override
    public XClass fromClass(Class<?> c) {
        if (c == null) {
            return null;
        }
        XClass xclass = this.classCache.get(c);
        if (xclass == null) {
            xclass = new ReflectionClass(c);
            this.classCache.put(c, xclass);
        }
        return xclass;
    }

    private static Class<?> determineCollectionElementType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
            if (actualTypeArguments.length == 1) {
                Type typeArg = actualTypeArguments[0];
                if (typeArg instanceof Class) {
                    return (Class)typeArg;
                }
                if (typeArg instanceof TypeVariable) {
                    return (Class)((TypeVariable)typeArg).getBounds()[0];
                }
                return (Class)((ParameterizedType)typeArg).getRawType();
            }
        } else if (genericType instanceof Class) {
            Class<?> x;
            Class c = (Class)genericType;
            if (c.getGenericSuperclass() != null && Collection.class.isAssignableFrom(c.getSuperclass()) && (x = ReflectionTypeFactory.determineCollectionElementType(c.getGenericSuperclass())) != null) {
                return x;
            }
            for (Type t : c.getGenericInterfaces()) {
                Class<?> x2;
                if ((!(t instanceof Class) || !Collection.class.isAssignableFrom((Class)t)) && (!(t instanceof ParameterizedType) || !Collection.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) || (x2 = ReflectionTypeFactory.determineCollectionElementType(t)) == null) continue;
                return x2;
            }
        }
        return null;
    }

    private final class ReflectionClass
    implements XClass {
        private final Class<?> clazz;
        private final Map<Field, ReflectionEnumConstant> enumConstants;
        private final Map<Constructor<?>, ReflectionConstructor> constructorCache = new HashMap();
        private final Map<Method, ReflectionMethod> methodCache = new HashMap<Method, ReflectionMethod>();
        private final Map<Field, ReflectionField> fieldCache = new HashMap<Field, ReflectionField>();

        ReflectionClass(Class<?> clazz) {
            this.clazz = clazz;
            if (clazz.isEnum()) {
                this.enumConstants = new LinkedHashMap<Field, ReflectionEnumConstant>();
                for (Field f : clazz.getDeclaredFields()) {
                    Enum e;
                    if (!f.isEnumConstant()) continue;
                    try {
                        f.setAccessible(true);
                        e = (Enum)f.get(clazz);
                    }
                    catch (IllegalAccessException iae) {
                        throw new IllegalStateException("Failed to access enum constant field", iae);
                    }
                    this.enumConstants.put(f, new ReflectionEnumConstant(this, e, f));
                }
            } else {
                this.enumConstants = null;
            }
        }

        @Override
        public XTypeFactory getFactory() {
            return ReflectionTypeFactory.this;
        }

        @Override
        public Class<?> asClass() {
            return this.clazz;
        }

        @Override
        public String getName() {
            return this.clazz.getName();
        }

        @Override
        public String getSimpleName() {
            return this.clazz.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.clazz.getCanonicalName();
        }

        @Override
        public String getPackageName() {
            return this.clazz.getPackage().getName();
        }

        @Override
        public boolean isPrimitive() {
            return this.clazz.isPrimitive();
        }

        @Override
        public boolean isEnum() {
            return this.clazz.isEnum();
        }

        @Override
        public boolean isArray() {
            return this.clazz.isArray();
        }

        @Override
        public XClass getComponentType() {
            if (!this.clazz.isArray()) {
                throw new IllegalStateException(this.getName() + " is not an array");
            }
            return ReflectionTypeFactory.this.fromClass(this.clazz.getComponentType());
        }

        @Override
        public XClass getEnclosingClass() {
            return ReflectionTypeFactory.this.fromClass(this.clazz.getEnclosingClass());
        }

        @Override
        public XClass getSuperclass() {
            return ReflectionTypeFactory.this.fromClass(this.clazz.getSuperclass());
        }

        @Override
        public XClass[] getInterfaces() {
            Class<?>[] interfaces = this.clazz.getInterfaces();
            XClass[] xInterfaces = new XClass[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                xInterfaces[i] = ReflectionTypeFactory.this.fromClass(interfaces[i]);
            }
            return xInterfaces;
        }

        @Override
        public String[] getGenericInterfaceParameterTypes(Class<?> c) {
            for (Class<?> i : this.clazz.getInterfaces()) {
                if (!c.isAssignableFrom(i)) continue;
                TypeVariable<Class<?>>[] typeParameters = i.getTypeParameters();
                String[] params = new String[typeParameters.length];
                int j = 0;
                for (TypeVariable<Class<?>> t : typeParameters) {
                    params[j++] = ((Object)t.getGenericDeclaration()).toString();
                }
                return params;
            }
            XClass superclass = this.getSuperclass();
            return superclass != null ? superclass.getGenericInterfaceParameterTypes(c) : null;
        }

        @Override
        public boolean isAssignableTo(XClass other) {
            if (this == other) {
                return true;
            }
            return other.asClass().isAssignableFrom(this.clazz);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.clazz.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.clazz.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getDocumentation() {
            return DocumentationExtractor.getDocumentation(this.clazz, false);
        }

        @Override
        public int getModifiers() {
            return this.clazz.getModifiers();
        }

        private ReflectionMethod cacheMethod(Method method) {
            if (method == null) {
                return null;
            }
            ReflectionClass declaringClass = (ReflectionClass)ReflectionTypeFactory.this.fromClass(method.getDeclaringClass());
            ReflectionMethod xmethod = declaringClass.methodCache.get(method);
            if (xmethod == null) {
                xmethod = new ReflectionMethod(declaringClass, method);
                declaringClass.methodCache.put(method, xmethod);
            }
            return xmethod;
        }

        private ReflectionConstructor cacheConstructor(Constructor<?> ctor) {
            if (ctor == null) {
                return null;
            }
            ReflectionConstructor xctor = this.constructorCache.get(ctor);
            if (xctor == null) {
                xctor = new ReflectionConstructor(this, ctor);
                this.constructorCache.put(ctor, xctor);
            }
            return xctor;
        }

        private ReflectionField cacheField(Field field) {
            ReflectionClass declaringClass = (ReflectionClass)ReflectionTypeFactory.this.fromClass(field.getDeclaringClass());
            ReflectionField xfield = declaringClass.fieldCache.get(field);
            if (xfield == null) {
                XEnumConstant enumConstant = field.isEnumConstant() ? (XEnumConstant)declaringClass.enumConstants.get(field) : null;
                xfield = new ReflectionField(declaringClass, field, enumConstant);
                declaringClass.fieldCache.put(field, xfield);
            }
            return xfield;
        }

        @Override
        public XConstructor getDeclaredConstructor(XClass ... xArgTypes) {
            Constructor<?> ctor;
            Class<?>[] argTypes = this.argsAsClass(xArgTypes);
            try {
                ctor = this.clazz.getDeclaredConstructor(argTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            return this.cacheConstructor(ctor);
        }

        @Override
        public Iterable<? extends XConstructor> getDeclaredConstructors() {
            ArrayList<ReflectionConstructor> constructors = new ArrayList<ReflectionConstructor>();
            for (Constructor<?> c : this.clazz.getDeclaredConstructors()) {
                constructors.add(this.cacheConstructor(c));
            }
            return constructors;
        }

        @Override
        public Iterable<? extends XMethod> getDeclaredMethods() {
            ArrayList<ReflectionMethod> methods = new ArrayList<ReflectionMethod>();
            for (Method m : this.clazz.getDeclaredMethods()) {
                methods.add(this.cacheMethod(m));
            }
            return methods;
        }

        @Override
        public XMethod getMethod(String methodName, XClass ... xArgTypes) {
            Method method = this.findMethod(this.clazz, methodName, this.argsAsClass(xArgTypes));
            return method == null ? null : this.cacheMethod(method);
        }

        private Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
            Method method;
            block4: {
                method = null;
                try {
                    method = clazz.getDeclaredMethod(methodName, argTypes);
                }
                catch (NoSuchMethodException e) {
                    Class<?> i;
                    if (clazz.getSuperclass() != null) {
                        method = this.findMethod(clazz.getSuperclass(), methodName, argTypes);
                    }
                    if (method != null) break block4;
                    Class<?>[] classArray = clazz.getInterfaces();
                    int n = classArray.length;
                    for (int j = 0; j < n && (method = this.findMethod(i = classArray[j], methodName, argTypes)) == null; ++j) {
                    }
                }
            }
            return method;
        }

        private Class<?>[] argsAsClass(XClass[] xArgTypes) {
            Class[] argTypes = null;
            if (xArgTypes != null) {
                argTypes = new Class[xArgTypes.length];
                for (int i = 0; i < xArgTypes.length; ++i) {
                    argTypes[i] = xArgTypes[i].asClass();
                }
            }
            return argTypes;
        }

        @Override
        public boolean isLocal() {
            return this.clazz.getEnclosingMethod() != null || this.clazz.getEnclosingConstructor() != null;
        }

        @Override
        public Iterable<? extends XField> getDeclaredFields() {
            ArrayList<ReflectionField> fields = new ArrayList<ReflectionField>();
            for (Field f : this.clazz.getDeclaredFields()) {
                fields.add(this.cacheField(f));
            }
            return fields;
        }

        @Override
        public Iterable<? extends XEnumConstant> getEnumConstants() {
            if (this.enumConstants != null) {
                return this.enumConstants.values();
            }
            throw new IllegalStateException(this.getName() + " is not an enum");
        }

        @Override
        public XEnumConstant getEnumConstant(String name) {
            if (this.enumConstants == null) {
                throw new IllegalStateException(this.getName() + " is not an enum");
            }
            for (Field f : this.enumConstants.keySet()) {
                if (!name.equals(f.getName())) continue;
                return this.enumConstants.get(f);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ReflectionClass)) {
                return false;
            }
            ReflectionClass other = (ReflectionClass)obj;
            return this.clazz == other.clazz;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public String toString() {
            return this.clazz.toString();
        }
    }

    private final class ReflectionField
    implements XField {
        private final ReflectionClass declaringClass;
        private final Field field;
        private final XEnumConstant enumConstant;

        ReflectionField(ReflectionClass declaringClass, Field field, XEnumConstant enumConstant) {
            this.declaringClass = declaringClass;
            this.field = field;
            this.enumConstant = enumConstant;
        }

        @Override
        public XClass getType() {
            return ReflectionTypeFactory.this.fromClass(this.field.getType());
        }

        @Override
        public XClass determineRepeatedElementType() {
            if (this.field.getType().isArray()) {
                return ReflectionTypeFactory.this.fromClass(this.field.getType().getComponentType());
            }
            if (Collection.class.isAssignableFrom(this.field.getType())) {
                Class<?> c = ReflectionTypeFactory.determineCollectionElementType(this.field.getGenericType());
                if (c == null) {
                    throw new IllegalStateException("Failed to determine element type of collection class " + c);
                }
                return ReflectionTypeFactory.this.fromClass(c);
            }
            throw log.notRepeatableField(this.declaringClass.getName(), this.field.getName());
        }

        @Override
        public boolean isEnumConstant() {
            return this.enumConstant != null;
        }

        @Override
        public XEnumConstant asEnumConstant() {
            if (this.enumConstant != null) {
                return this.enumConstant;
            }
            throw new IllegalStateException(this.getName() + " is not an enum constant");
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public int getModifiers() {
            return this.field.getModifiers();
        }

        @Override
        public XClass getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.field.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getDocumentation() {
            return DocumentationExtractor.getDocumentation(this.field, false);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ReflectionField.class) {
                return false;
            }
            return this.field.equals(((ReflectionField)obj).field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public String toString() {
            return this.field.toString();
        }
    }

    private final class ReflectionConstructor
    implements XConstructor {
        private final ReflectionClass declaringClass;
        private final Constructor<?> constructor;

        ReflectionConstructor(ReflectionClass declaringClass, Constructor<?> constructor) {
            this.declaringClass = declaringClass;
            this.constructor = constructor;
        }

        @Override
        public int getParameterCount() {
            return this.constructor.getParameterCount();
        }

        @Override
        public String[] getParameterNames() {
            Parameter[] parameters = this.constructor.getParameters();
            String[] parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                if (!parameters[i].isNamePresent()) {
                    throw new IllegalStateException("Method parameter names are not present in compiled class file: " + this.constructor.getDeclaringClass().getName() + ". Please enable them at compile time.");
                }
                parameterNames[i] = parameters[i].getName();
            }
            return parameterNames;
        }

        @Override
        public XClass[] getParameterTypes() {
            Class<?>[] parameterTypes = this.constructor.getParameterTypes();
            XClass[] xparameterTypes = new XClass[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                xparameterTypes[i] = ReflectionTypeFactory.this.fromClass(parameterTypes[i]);
            }
            return xparameterTypes;
        }

        @Override
        public String getName() {
            return this.constructor.getName();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers();
        }

        @Override
        public XClass getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return (A)this.constructor.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.constructor.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getDocumentation() {
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ReflectionConstructor.class) {
                return false;
            }
            return this.constructor.equals(((ReflectionConstructor)obj).constructor);
        }

        public int hashCode() {
            return this.constructor.hashCode();
        }

        public String toString() {
            return this.constructor.toString();
        }

        @Override
        public String toGenericString() {
            return this.constructor.toGenericString();
        }
    }

    private final class ReflectionMethod
    implements XMethod {
        private final ReflectionClass declaringClass;
        private final Method method;

        ReflectionMethod(ReflectionClass declaringClass, Method method) {
            this.declaringClass = declaringClass;
            this.method = method;
        }

        @Override
        public XClass getReturnType() {
            return ReflectionTypeFactory.this.fromClass(this.method.getReturnType());
        }

        @Override
        public XClass determineRepeatedElementType() {
            Class<?> returnType = this.unwrapOptionalReturnType();
            if (returnType.isArray()) {
                return ReflectionTypeFactory.this.fromClass(returnType.getComponentType());
            }
            if (Collection.class.isAssignableFrom(returnType)) {
                Class<?> c = ReflectionTypeFactory.determineCollectionElementType(this.unwrapOptionalReturnTypeGeneric());
                if (c == null) {
                    throw new IllegalStateException("Failed to determine element type of collection class " + c);
                }
                return ReflectionTypeFactory.this.fromClass(c);
            }
            throw log.notRepeatableField(this.declaringClass.getName(), this.method.getName());
        }

        @Override
        public XClass determineOptionalReturnType() {
            return ReflectionTypeFactory.this.fromClass(this.unwrapOptionalReturnType());
        }

        private Class<?> unwrapOptionalReturnType() {
            Type t = this.unwrapOptionalReturnTypeGeneric();
            if (t instanceof ParameterizedType) {
                t = ((ParameterizedType)t).getRawType();
            }
            return (Class)t;
        }

        private Type unwrapOptionalReturnTypeGeneric() {
            if (Optional.class == this.method.getReturnType()) {
                return ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
            }
            return this.method.getGenericReturnType();
        }

        @Override
        public int getParameterCount() {
            return this.method.getParameterCount();
        }

        @Override
        public String[] getParameterNames() {
            Parameter[] parameters = this.method.getParameters();
            String[] parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                if (!parameters[i].isNamePresent()) {
                    throw new IllegalStateException("Method parameter names are not present in compiled class file: " + this.method.getDeclaringClass().getName() + ". Please enable them at compile time.");
                }
                parameterNames[i] = parameters[i].getName();
            }
            return parameterNames;
        }

        @Override
        public XClass[] getParameterTypes() {
            Class<?>[] paramTypes = this.method.getParameterTypes();
            XClass[] xparamTypes = new XClass[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                xparamTypes[i] = ReflectionTypeFactory.this.fromClass(paramTypes[i]);
            }
            return xparamTypes;
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public XClass getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.method.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.method.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getDocumentation() {
            return DocumentationExtractor.getDocumentation(this.method, false);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ReflectionMethod.class) {
                return false;
            }
            return this.method.equals(((ReflectionMethod)obj).method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public String toGenericString() {
            return this.method.toGenericString();
        }
    }

    private static final class ReflectionEnumConstant
    implements XEnumConstant {
        private final XClass declaringClass;
        private final Enum<?> e;
        private final Field f;

        private ReflectionEnumConstant(XClass declaringClass, Enum<?> e, Field f) {
            this.declaringClass = declaringClass;
            this.e = e;
            this.f = f;
        }

        @Override
        public int getOrdinal() {
            return this.e.ordinal();
        }

        @Override
        public String getName() {
            return this.e.name();
        }

        @Override
        public int getModifiers() {
            return this.f.getModifiers();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.f.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.f.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getDocumentation() {
            return DocumentationExtractor.getDocumentation(this.f, false);
        }

        @Override
        public XClass getDeclaringClass() {
            return this.declaringClass;
        }
    }
}

