/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.invocation.MatchableInvocation;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubbing;

public class StubbedInvocationMatcher
extends InvocationMatcher
implements Serializable,
Stubbing {
    private static final long serialVersionUID = 4919105134123672727L;
    private final Queue<Answer> answers = new ConcurrentLinkedQueue<Answer>();
    private final Strictness strictness;
    private final Object usedAtLock = new Object[0];
    private DescribedInvocation usedAt;

    public StubbedInvocationMatcher(Answer answer, MatchableInvocation invocation, Strictness strictness) {
        super(invocation.getInvocation(), invocation.getMatchers());
        this.strictness = strictness;
        this.answers.add(answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Answer a;
        Queue<Answer> queue = this.answers;
        synchronized (queue) {
            a = this.answers.size() == 1 ? this.answers.peek() : this.answers.poll();
        }
        return a.answer(invocation);
    }

    public void addAnswer(Answer answer) {
        this.answers.add(answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markStubUsed(DescribedInvocation usedAt) {
        Object object = this.usedAtLock;
        synchronized (object) {
            this.usedAt = usedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasUsed() {
        Object object = this.usedAtLock;
        synchronized (object) {
            return this.usedAt != null;
        }
    }

    @Override
    public String toString() {
        return super.toString() + " stubbed with: " + this.answers;
    }

    @Override
    public Strictness getStrictness() {
        return this.strictness;
    }
}

