/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.internal.util.type.PrimitiveWrapperHelper;

public class ConverterHelper {
    public static ParameterizedType extractAttributeConverterParameterizedType(Class<? extends AttributeConverter<?, ?>> base) {
        return GenericsHelper.extractParameterizedType(base);
    }

    public static ResolvedType resolveAttributeType(XProperty xProperty, MetadataBuildingContext context) {
        return ConverterHelper.resolveMember(xProperty, context).getType();
    }

    public static ResolvedMember<? extends Member> resolveMember(XProperty xProperty, MetadataBuildingContext buildingContext) {
        ClassmateContext classmateContext = buildingContext.getBootstrapContext().getClassmateContext();
        ReflectionManager reflectionManager = buildingContext.getBootstrapContext().getReflectionManager();
        ResolvedType declaringClassType = classmateContext.getTypeResolver().resolve((Type)reflectionManager.toClass(xProperty.getDeclaringClass()), new Type[0]);
        ResolvedTypeWithMembers declaringClassWithMembers = classmateContext.getMemberResolver().resolve(declaringClassType, null, null);
        Member member = ConverterHelper.toMember(xProperty);
        if (member instanceof Method) {
            for (ResolvedMethod resolvedMember : declaringClassWithMembers.getMemberMethods()) {
                if (!resolvedMember.getName().equals(member.getName())) continue;
                return resolvedMember;
            }
        } else if (member instanceof Field) {
            for (ResolvedField resolvedMember : declaringClassWithMembers.getMemberFields()) {
                if (!resolvedMember.getName().equals(member.getName())) continue;
                return resolvedMember;
            }
        } else {
            throw new HibernateException("Unexpected java.lang.reflect.Member type from org.hibernate.annotations.common.reflection.java.JavaXMember : " + member);
        }
        throw new HibernateException("Could not locate resolved type information for attribute [" + member.getName() + "] from Classmate");
    }

    public static Member toMember(XProperty xProperty) {
        try {
            return HCANNHelper.getUnderlyingMember(xProperty);
        }
        catch (Exception e) {
            throw new HibernateException("Could not resolve member signature from XProperty reference", e);
        }
    }

    public static List<ResolvedType> resolveConverterClassParamTypes(Class<? extends AttributeConverter<?, ?>> converterClass, ClassmateContext context) {
        ResolvedType converterType = context.getTypeResolver().resolve(converterClass, new Type[0]);
        List converterParamTypes = converterType.typeParametersFor(AttributeConverter.class);
        if (converterParamTypes == null) {
            throw new AnnotationException("Could not extract type argument from attribute converter class '" + converterClass.getName() + "'");
        }
        if (converterParamTypes.size() != 2) {
            throw new AnnotationException("Unexpected type argument for attribute converter class '" + converterClass.getName() + "' (expected 2 type arguments, but found " + converterParamTypes.size() + ")");
        }
        return converterParamTypes;
    }

    public static boolean typesMatch(ResolvedType converterDefinedType, ResolvedType checkType) {
        Class erasedCheckType = checkType.getErasedType();
        if (erasedCheckType.isPrimitive()) {
            erasedCheckType = PrimitiveWrapperHelper.getDescriptorByPrimitiveType(erasedCheckType).getWrapperClass();
        } else if (erasedCheckType.isArray()) {
            return converterDefinedType.getErasedType() == erasedCheckType;
        }
        if (!converterDefinedType.getErasedType().isAssignableFrom(erasedCheckType)) {
            return false;
        }
        if (converterDefinedType.getTypeParameters().isEmpty()) {
            return true;
        }
        if (checkType.getTypeParameters().isEmpty()) {
            return false;
        }
        if (converterDefinedType.getTypeParameters().size() != checkType.getTypeParameters().size()) {
            return false;
        }
        for (int i = 0; i < converterDefinedType.getTypeParameters().size(); ++i) {
            if (ConverterHelper.typesMatch((ResolvedType)converterDefinedType.getTypeParameters().get(i), (ResolvedType)checkType.getTypeParameters().get(i))) continue;
            return false;
        }
        return true;
    }
}

