/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.utils;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.functions.Either;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;

public final class CircuitBreakerResultUtils {
    private CircuitBreakerResultUtils() {
    }

    public static boolean isFailedWith(Either<Object, Throwable> result, Class<? extends Throwable> exceptionClass) {
        return result.isRight() && exceptionClass.isAssignableFrom(((Throwable)result.get()).getClass());
    }

    public static <T extends Throwable> TransitionCheckThrowableBuilder<T> ifFailedWith(Class<T> exceptionClass) {
        return new TransitionCheckThrowableBuilder<T>(exceptionClass);
    }

    public static class TransitionCheckThrowableBuilder<T extends Throwable> {
        private final Class<T> exceptionClass;

        private TransitionCheckThrowableBuilder(Class<T> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        public Function<Either<Object, Throwable>, CircuitBreakerConfig.TransitionCheckResult> thenOpen() {
            return result -> CircuitBreakerResultUtils.isFailedWith((Either<Object, Throwable>)result, this.exceptionClass) ? CircuitBreakerConfig.TransitionCheckResult.transitionToOpen() : CircuitBreakerConfig.TransitionCheckResult.noTransition();
        }

        public Function<Either<Object, Throwable>, CircuitBreakerConfig.TransitionCheckResult> thenOpenFor(Function<T, Duration> waitDurationExtractor) {
            return result -> CircuitBreakerResultUtils.isFailedWith((Either<Object, Throwable>)result, this.exceptionClass) ? CircuitBreakerConfig.TransitionCheckResult.transitionToOpenAndWaitFor((Duration)waitDurationExtractor.apply((Throwable)result.get())) : CircuitBreakerConfig.TransitionCheckResult.noTransition();
        }

        public Function<Either<Object, Throwable>, CircuitBreakerConfig.TransitionCheckResult> thenOpenUntil(Function<T, Instant> waitUntilExtractor) {
            return result -> CircuitBreakerResultUtils.isFailedWith((Either<Object, Throwable>)result, this.exceptionClass) ? CircuitBreakerConfig.TransitionCheckResult.transitionToOpenAndWaitUntil((Instant)waitUntilExtractor.apply((Throwable)result.get())) : CircuitBreakerConfig.TransitionCheckResult.noTransition();
        }
    }
}

