/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class OracleServerConfiguration {
    private final boolean autonomous;
    private final boolean extended;
    private final boolean applicationContinuity;
    private final int driverMajorVersion;
    private final int driverMinorVersion;

    public boolean isAutonomous() {
        return this.autonomous;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isApplicationContinuity() {
        return this.applicationContinuity;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public OracleServerConfiguration(boolean autonomous, boolean extended) {
        this(autonomous, extended, false, 19, 0);
    }

    public OracleServerConfiguration(boolean autonomous, boolean extended, int driverMajorVersion, int driverMinorVersion) {
        this(autonomous, extended, false, driverMajorVersion, driverMinorVersion);
    }

    public OracleServerConfiguration(boolean autonomous, boolean extended, boolean applicationContinuity, int driverMajorVersion, int driverMinorVersion) {
        this.autonomous = autonomous;
        this.extended = extended;
        this.applicationContinuity = applicationContinuity;
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
    }

    public static OracleServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        Boolean extended = null;
        Boolean autonomous = null;
        Boolean applicationContinuity = null;
        Integer majorVersion = null;
        Integer minorVersion = null;
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            majorVersion = databaseMetaData.getDriverMajorVersion();
            minorVersion = databaseMetaData.getDriverMinorVersion();
            try {
                Connection c = databaseMetaData.getConnection();
                try (Statement statement = c.createStatement();){
                    try {
                        Class<?> statisticReportTypeEnum = Class.forName("oracle.jdbc.replay.ReplayableConnection$StatisticsReportType", false, Thread.currentThread().getContextClassLoader());
                        Field forCurrentConnection = statisticReportTypeEnum.getField("FOR_CURRENT_CONNECTION");
                        Method getReplayStatistics = c.getClass().getMethod("getReplayStatistics", statisticReportTypeEnum);
                        Object stats = getReplayStatistics.invoke((Object)c, forCurrentConnection.get(null));
                        Method getTotalRequests = stats.getClass().getMethod("getTotalRequests", new Class[0]);
                        Method getTotalProtectedCalls = stats.getClass().getMethod("getTotalProtectedCalls", new Class[0]);
                        Long totalRequestsBefore = (Long)getTotalRequests.invoke(stats, new Object[0]);
                        Long protectedCallsBefore = (Long)getTotalProtectedCalls.invoke(stats, new Object[0]);
                        try (ResultSet r = statement.executeQuery("select 1");){
                            r.next();
                        }
                        stats = getReplayStatistics.invoke((Object)c, forCurrentConnection.get(null));
                        Long totalRequestsAfter = (Long)getTotalRequests.invoke(stats, new Object[0]);
                        Long protectedCallsAfter = (Long)getTotalProtectedCalls.invoke(stats, new Object[0]);
                        applicationContinuity = totalRequestsAfter > totalRequestsBefore && protectedCallsAfter > protectedCallsBefore;
                    }
                    catch (Exception e) {
                        applicationContinuity = false;
                    }
                    ResultSet rs = statement.executeQuery("select cast('string' as varchar2(32000)), sys_context('USERENV','CLOUD_SERVICE') from dual");
                    if (rs.next()) {
                        extended = true;
                        autonomous = OracleServerConfiguration.isAutonomous(rs.getString(2));
                    }
                }
            }
            catch (SQLException ex) {
                extended = false;
                autonomous = OracleServerConfiguration.isAutonomous(databaseMetaData);
            }
        }
        if (extended == null) {
            extended = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.extended_string_size", info.getConfigurationValues(), false);
        }
        if (autonomous == null) {
            autonomous = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.is_autonomous", info.getConfigurationValues(), false);
        }
        if (applicationContinuity == null) {
            applicationContinuity = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.application_continuity", info.getConfigurationValues(), false);
        }
        if (majorVersion == null) {
            try {
                Driver driver = DriverManager.getDriver("jdbc:oracle:thin:");
                majorVersion = driver.getMajorVersion();
                minorVersion = driver.getMinorVersion();
            }
            catch (SQLException ex) {
                majorVersion = 19;
                minorVersion = 0;
            }
        }
        return new OracleServerConfiguration(autonomous, extended, applicationContinuity, majorVersion, minorVersion);
    }

    private static boolean isAutonomous(String cloudServiceParam) {
        return cloudServiceParam != null && List.of("OLTP", "DWCS", "JDCS").contains(cloudServiceParam);
    }

    private static boolean isAutonomous(DatabaseMetaData databaseMetaData) {
        boolean bl;
        block8: {
            Statement statement = databaseMetaData.getConnection().createStatement();
            try {
                bl = statement.executeQuery("select 1 from dual where sys_context('USERENV','CLOUD_SERVICE') in ('OLTP','DWCS','JDCS')").next();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }
}

