/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.DomainModelHelper;
import org.hibernate.metamodel.model.domain.internal.EntityDiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.persister.entity.DiscriminatorMetadata;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.query.PathException;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityTypeImpl<J>
extends AbstractIdentifiableType<J>
implements EntityDomainType<J>,
Serializable {
    private final String jpaEntityName;
    private final JpaMetamodelImplementor metamodel;
    private final SqmPathSource<?> discriminatorPathSource;

    public EntityTypeImpl(String entityName, String jpaEntityName, boolean hasIdClass, boolean hasIdProperty, boolean hasVersion, JavaType<J> javaType, IdentifiableDomainType<? super J> superType, JpaMetamodelImplementor metamodel) {
        super(entityName, javaType, superType, hasIdClass, hasIdProperty, hasVersion, metamodel);
        this.jpaEntityName = jpaEntityName;
        this.metamodel = metamodel;
        Queryable entityDescriptor = (Queryable)metamodel.getMappingMetamodel().getEntityDescriptor(this.getHibernateEntityName());
        DiscriminatorMetadata discriminatorMetadata = entityDescriptor.getTypeDiscriminatorMetadata();
        BasicType<String> discriminatorType = discriminatorMetadata != null ? (BasicType<String>)discriminatorMetadata.getResolutionType() : metamodel.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
        this.discriminatorPathSource = discriminatorType == null ? null : new EntityDiscriminatorSqmPathSource<String>(discriminatorType, this, entityDescriptor);
    }

    public EntityTypeImpl(JavaType<J> javaType, IdentifiableDomainType<? super J> superType, PersistentClass persistentClass, JpaMetamodelImplementor metamodel) {
        this(persistentClass.getEntityName(), persistentClass.getJpaEntityName(), persistentClass.getDeclaredIdentifierMapper() != null || superType != null && superType.hasIdClass(), persistentClass.hasIdentifierProperty(), persistentClass.isVersioned(), javaType, superType, metamodel);
    }

    public EntityTypeImpl(JavaType<J> javaTypeDescriptor, JpaMetamodelImplementor metamodel) {
        super(javaTypeDescriptor.getJavaTypeClass().getName(), javaTypeDescriptor, null, false, false, false, metamodel);
        this.jpaEntityName = javaTypeDescriptor.getJavaTypeClass().getName();
        this.metamodel = metamodel;
        this.discriminatorPathSource = null;
    }

    public String getName() {
        return this.jpaEntityName;
    }

    @Override
    public String getHibernateEntityName() {
        return super.getTypeName();
    }

    @Override
    public String getPathName() {
        return this.getHibernateEntityName();
    }

    @Override
    public EntityDomainType<J> getSqmPathType() {
        return this;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        PersistentAttribute<J, ?> attribute = this.findAttribute(name);
        if (attribute != null) {
            return (SqmPathSource)((Object)attribute);
        }
        if (EntityIdentifierMapping.matchesRoleName(name)) {
            return this.hasSingleIdAttribute() ? this.findIdAttribute() : this.getIdentifierDescriptor();
        }
        if (EntityDiscriminatorMapping.matchesRoleName(name)) {
            return this.discriminatorPathSource;
        }
        return null;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name, JpaMetamodelImplementor metamodel) {
        PersistentAttribute attribute = super.findAttribute(name);
        if (attribute != null) {
            return (SqmPathSource)((Object)attribute);
        }
        PersistentAttribute<?, ?> subtypeAttribute = this.findSubtypeAttribute(name, metamodel);
        if (subtypeAttribute != null) {
            return (SqmPathSource)((Object)subtypeAttribute);
        }
        if (EntityIdentifierMapping.matchesRoleName(name)) {
            return this.hasSingleIdAttribute() ? this.findIdAttribute() : this.getIdentifierDescriptor();
        }
        if (EntityDiscriminatorMapping.matchesRoleName(name)) {
            return this.discriminatorPathSource;
        }
        return null;
    }

    private PersistentAttribute<?, ?> findSubtypeAttribute(String name, JpaMetamodelImplementor metamodel) {
        PersistentAttribute<?, ?> subtypeAttribute = null;
        for (ManagedDomainType managedDomainType : this.getSubTypes()) {
            PersistentAttribute<?, ?> candidate = managedDomainType.findSubTypesAttribute(name);
            if (candidate == null) continue;
            if (subtypeAttribute != null && !DomainModelHelper.isCompatible(subtypeAttribute, candidate, metamodel)) {
                throw new PathException(String.format(Locale.ROOT, "Could not resolve attribute '%s' of '%s' due to the attribute being declared in multiple subtypes '%s' and '%s'", name, this.getTypeName(), subtypeAttribute.getDeclaringType().getTypeName(), candidate.getDeclaringType().getTypeName()));
            }
            subtypeAttribute = candidate;
        }
        return subtypeAttribute;
    }

    @Override
    public PersistentAttribute<? super J, ?> findAttribute(String name) {
        PersistentAttribute attribute = super.findAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if (EntityIdentifierMapping.matchesRoleName(name)) {
            return this.findIdAttribute();
        }
        return null;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public IdentifiableDomainType<? super J> getSuperType() {
        return super.getSuperType();
    }

    @Override
    public Collection<? extends EntityDomainType<? extends J>> getSubTypes() {
        return super.getSubTypes();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedMappingException("EntityType cannot be used to create an SqmPath - that would be an SqmFrom which are created directly");
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.metamodel, this.getHibernateEntityName());
    }

    private static class SerialForm
    implements Serializable {
        private final JpaMetamodel jpaMetamodel;
        private final String hibernateEntityName;

        public SerialForm(JpaMetamodel jpaMetamodel, String hibernateEntityName) {
            this.jpaMetamodel = jpaMetamodel;
            this.hibernateEntityName = hibernateEntityName;
        }

        private Object readResolve() {
            return this.jpaMetamodel.entity(this.hibernateEntityName);
        }
    }
}

