/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

public class ExportHelp {
    private final DeployitCommunicator communicator;

    public ExportHelp(DeployitCommunicator communicator) {
        this.communicator = communicator;
    }

    public long writeResourceToLocalFile(String filePath, String resourceURL) throws IOException {
        HttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet("/" + resourceURL);
            response = this.communicator.httpClient().execute(this.communicator.getHttpClientHolder().getHost(), (HttpRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                long l = ExportHelp.writeFile(filePath, response);
                return l;
            }
            if (statusCode == 401 || statusCode == 403) {
                throw new DeployitClientException("You were not authenticated correctly, did you use the correct credentials?", statusCode);
            }
            Object errorMessage = "An error occured: " + response.getStatusLine();
            if (response.getEntity() != null) {
                errorMessage = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            throw new DeployitClientException((String)errorMessage, statusCode);
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static long writeFile(String filePath, HttpResponse response) throws IOException {
        try (FileOutputStream outputResourceFile = new FileOutputStream(filePath);){
            long l;
            block13: {
                InputStream content = response.getEntity().getContent();
                try {
                    ByteStreams.copy((InputStream)content, (OutputStream)outputResourceFile);
                    l = 1L;
                    if (content == null) break block13;
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                content.close();
            }
            return l;
        }
        catch (IOException outputFileException) {
            throw new IOException(String.format("The file at %s could not be created.", filePath));
        }
    }
}

