/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

final class JwtDecoderProviderConfigurationUtils {
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private static final String OAUTH_METADATA_PATH = "/.well-known/oauth-authorization-server";
    private static final RestTemplate rest = new RestTemplate();
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP;

    private JwtDecoderProviderConfigurationUtils() {
    }

    static Map<String, Object> getConfigurationForOidcIssuerLocation(String oidcIssuerLocation) {
        return JwtDecoderProviderConfigurationUtils.getConfiguration(oidcIssuerLocation, (RestOperations)rest, JwtDecoderProviderConfigurationUtils.oidc(URI.create(oidcIssuerLocation)));
    }

    static Map<String, Object> getConfigurationForIssuerLocation(String issuer, RestOperations rest) {
        URI uri = URI.create(issuer);
        return JwtDecoderProviderConfigurationUtils.getConfiguration(issuer, rest, JwtDecoderProviderConfigurationUtils.oidc(uri), JwtDecoderProviderConfigurationUtils.oidcRfc8414(uri), JwtDecoderProviderConfigurationUtils.oauth(uri));
    }

    static Map<String, Object> getConfigurationForIssuerLocation(String issuer) {
        return JwtDecoderProviderConfigurationUtils.getConfigurationForIssuerLocation(issuer, (RestOperations)rest);
    }

    static void validateIssuer(Map<String, Object> configuration, String issuer) {
        String metadataIssuer = JwtDecoderProviderConfigurationUtils.getMetadataIssuer(configuration);
        Assert.state((boolean)issuer.equals(metadataIssuer), () -> "The Issuer \"" + metadataIssuer + "\" provided in the configuration did not match the requested issuer \"" + issuer + "\"");
    }

    static <C extends SecurityContext> void addJWSAlgorithms(ConfigurableJWTProcessor<C> jwtProcessor) {
        JWSKeySelector selector = jwtProcessor.getJWSKeySelector();
        if (selector instanceof JWSVerificationKeySelector) {
            JWKSource jwkSource = ((JWSVerificationKeySelector)selector).getJWKSource();
            Set<JWSAlgorithm> algorithms = JwtDecoderProviderConfigurationUtils.getJWSAlgorithms(jwkSource);
            selector = new JWSVerificationKeySelector(algorithms, jwkSource);
            jwtProcessor.setJWSKeySelector(selector);
        }
    }

    static <C extends SecurityContext> Set<JWSAlgorithm> getJWSAlgorithms(JWKSource<C> jwkSource) {
        JWKMatcher jwkMatcher = new JWKMatcher.Builder().publicOnly(true).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).keyTypes(new KeyType[]{KeyType.RSA, KeyType.EC}).build();
        HashSet<JWSAlgorithm> jwsAlgorithms = new HashSet<JWSAlgorithm>();
        try {
            List jwks = jwkSource.get(new JWKSelector(jwkMatcher), null);
            for (JWK jwk : jwks) {
                if (jwk.getAlgorithm() != null) {
                    JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)jwk.getAlgorithm().getName());
                    jwsAlgorithms.add(jwsAlgorithm);
                    continue;
                }
                if (jwk.getKeyType() == KeyType.RSA) {
                    jwsAlgorithms.addAll((Collection<JWSAlgorithm>)JWSAlgorithm.Family.RSA);
                    continue;
                }
                if (jwk.getKeyType() != KeyType.EC) continue;
                jwsAlgorithms.addAll((Collection<JWSAlgorithm>)JWSAlgorithm.Family.EC);
            }
        }
        catch (KeySourceException ex) {
            throw new IllegalStateException(ex);
        }
        Assert.notEmpty(jwsAlgorithms, (String)"Failed to find any algorithms from the JWK set");
        return jwsAlgorithms;
    }

    static Set<SignatureAlgorithm> getSignatureAlgorithms(JWKSource<SecurityContext> jwkSource) {
        Set<JWSAlgorithm> jwsAlgorithms = JwtDecoderProviderConfigurationUtils.getJWSAlgorithms(jwkSource);
        HashSet<SignatureAlgorithm> signatureAlgorithms = new HashSet<SignatureAlgorithm>();
        for (JWSAlgorithm jwsAlgorithm : jwsAlgorithms) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.from(jwsAlgorithm.getName());
            if (signatureAlgorithm == null) continue;
            signatureAlgorithms.add(signatureAlgorithm);
        }
        return signatureAlgorithms;
    }

    private static String getMetadataIssuer(Map<String, Object> configuration) {
        if (configuration.containsKey("issuer")) {
            return configuration.get("issuer").toString();
        }
        return "(unavailable)";
    }

    private static Map<String, Object> getConfiguration(String issuer, RestOperations rest, URI ... uris) {
        String errorMessage = "Unable to resolve the Configuration with the provided Issuer of \"" + issuer + "\"";
        for (URI uri : uris) {
            try {
                RequestEntity request = RequestEntity.get((URI)uri).build();
                ResponseEntity response = rest.exchange(request, STRING_OBJECT_MAP);
                Map configuration = (Map)response.getBody();
                Assert.isTrue((configuration.get("jwks_uri") != null ? 1 : 0) != 0, (String)"The public JWK set URI must not be null");
                return configuration;
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                if (ex instanceof HttpClientErrorException && ((HttpClientErrorException)ex).getStatusCode().is4xxClientError()) continue;
                throw new IllegalArgumentException(errorMessage, ex);
            }
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private static URI oidc(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(issuer.getPath() + OIDC_METADATA_PATH).build(Collections.emptyMap());
    }

    private static URI oidcRfc8414(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(OIDC_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }

    private static URI oauth(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(OAUTH_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }

    static {
        int connectTimeout = Integer.parseInt(System.getProperty("sun.net.client.defaultConnectTimeout", "30000"));
        int readTimeout = Integer.parseInt(System.getProperty("sun.net.client.defaultReadTimeout", "30000"));
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(connectTimeout);
        requestFactory.setReadTimeout(readTimeout);
        rest.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    }
}

