/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class AnnotatedTypeScanner
implements ResourceLoaderAware,
EnvironmentAware {
    private final Iterable<Class<? extends Annotation>> annotationTypes;
    private final boolean considerInterfaces;
    @Nullable
    private ResourceLoader resourceLoader;
    @Nullable
    private Environment environment;
    private Consumer<ClassNotFoundException> classNotFoundAction = ex -> {
        throw new IllegalStateException((Throwable)ex);
    };

    @SafeVarargs
    public AnnotatedTypeScanner(Class<? extends Annotation> ... annotationTypes) {
        this(true, annotationTypes);
    }

    @SafeVarargs
    public AnnotatedTypeScanner(boolean considerInterfaces, Class<? extends Annotation> ... annotationTypes) {
        this(considerInterfaces, Arrays.asList(annotationTypes));
    }

    public AnnotatedTypeScanner(boolean considerInterfaces, Collection<Class<? extends Annotation>> annotationTypes) {
        this.considerInterfaces = considerInterfaces;
        this.annotationTypes = annotationTypes;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    void setClassNotFoundAction(Consumer<ClassNotFoundException> classNotFoundAction) {
        this.classNotFoundAction = classNotFoundAction;
    }

    public Set<Class<?>> findTypes(String ... basePackages) {
        return this.findTypes(Arrays.asList(basePackages));
    }

    Set<Class<?>> findTypes(Iterable<String> basePackages, Collection<TypeFilter> filters) {
        InterfaceAwareScanner provider = new InterfaceAwareScanner(this.considerInterfaces);
        if (this.resourceLoader != null) {
            provider.setResourceLoader(this.resourceLoader);
        }
        if (this.environment != null) {
            provider.setEnvironment(this.environment);
        }
        filters.forEach(arg_0 -> ((ClassPathScanningCandidateComponentProvider)provider).addIncludeFilter(arg_0));
        HashSet types = new HashSet();
        ResourceLoader loader = this.resourceLoader;
        ClassLoader classLoader = loader == null ? null : loader.getClassLoader();
        for (String basePackage : basePackages) {
            for (BeanDefinition definition : provider.findCandidateComponents(basePackage)) {
                String beanClassName = definition.getBeanClassName();
                if (beanClassName == null) {
                    throw new IllegalStateException(String.format("Unable to obtain bean class name from bean definition %s!", definition));
                }
                try {
                    types.add(ClassUtils.forName((String)beanClassName, (ClassLoader)classLoader));
                }
                catch (ClassNotFoundException o_O) {
                    this.classNotFoundAction.accept(o_O);
                }
            }
        }
        return types;
    }

    public Set<Class<?>> findTypes(Iterable<String> basePackages) {
        return this.findTypes(basePackages, Streamable.of(this.annotationTypes).stream().map(annotation -> new AnnotationTypeFilter(annotation, true, this.considerInterfaces)).collect(Collectors.toSet()));
    }

    private static class InterfaceAwareScanner
    extends ClassPathScanningCandidateComponentProvider {
        private final boolean considerInterfaces;

        public InterfaceAwareScanner(boolean considerInterfaces) {
            super(false);
            this.considerInterfaces = considerInterfaces;
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return super.isCandidateComponent(beanDefinition) || this.considerInterfaces && beanDefinition.getMetadata().isInterface();
        }
    }
}

