/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.local;

import ai.digital.deploy.permissions.api.rest.dto.ReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.PermissionServiceClient;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ConditionalOnProperty(name={"xl.permission-service.enabled"}, havingValue="true", matchIfMissing=true)
@Service
@Profile(value={"permission-service"})
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001B\u0001B\u0003%Q\tC\u0003J\u0001\u0011\u0005!\nC\u0003T\u0001\u0011\u0005C\u000b\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\u0003\u0001\t\u0003\ni\u0003C\u0004\u0002\f\u0001!\t%a\u000f\t\u000f\u0005-\u0001\u0001\"\u0011\u0002P!9\u00111\f\u0001\u0005B\u0005u\u0003bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u00037\u0002A\u0011IAM\u0011\u001d\t)\t\u0001C!\u0003?\u0013Q\u0004T8dC2\u0004VM]7jgNLwN\\:TKJ4\u0018nY3DY&,g\u000e\u001e\u0006\u0003%M\tQ\u0001\\8dC2T!\u0001F\u000b\u0002\r\rd\u0017.\u001a8u\u0015\t1r#A\u0006qKJl\u0017n]:j_:\u001c(B\u0001\r\u001a\u0003\u0019!W\r\u001d7ps*\u0011!dG\u0001\bI&<\u0017\u000e^1m\u0015\u0005a\u0012AA1j\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002'%\u0011\u0001f\u0005\u0002\u0018!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,7\t\\5f]R\fqc\u001a7pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005-rS\"\u0001\u0017\u000b\u00055*\u0012aB:feZL7-Z\u0005\u0003_1\u0012qc\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3)\u0005\u0005\t\u0004C\u0001\u001a>\u001b\u0005\u0019$B\u0001\u001b6\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003m]\nqAZ1di>\u0014\u0018P\u0003\u00029s\u0005)!-Z1og*\u0011!hO\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA(A\u0002pe\u001eL!AP\u001a\u0003\u0013\u0005+Ho\\<je\u0016$\u0017a\u0007:fM\u0016\u0014XM\\2fIB+'/\\5tg&|gnU3sm&\u001cW\r\u0005\u0002,\u0003&\u0011!\t\f\u0002\u001c%\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3)\u0005\t\t\u0014a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u000b$\n\u0005\u001dc#a\u0003*pY\u0016\u001cVM\u001d<jG\u0016D#aA\u0019\u0002\rqJg.\u001b;?)\u0011YUjT)\u0011\u00051\u0003Q\"A\t\t\u000b%\"\u0001\u0019\u0001\u0016)\u00055\u000b\u0004\"B \u0005\u0001\u0004\u0001\u0005FA(2\u0011\u0015!E\u00011\u0001FQ\t\t\u0016'\u0001\bde\u0016\fG/Z(s+B$\u0017\r^3\u0015\u000bUCVM]?\u0011\u0005\u00012\u0016BA,\"\u0005\u0011)f.\u001b;\t\u000be+\u0001\u0019\u0001.\u0002!I,g-\u001a:f]\u000e,\u0017\nZ'bs\n,\u0007c\u0001\u0011\\;&\u0011A,\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001B;uS2T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n!Q+V%E\u0011\u00151W\u00011\u0001h\u0003!\u0011x\u000e\\3OC6,\u0007C\u00015p\u001d\tIW\u000e\u0005\u0002kC5\t1N\u0003\u0002m;\u00051AH]8pizJ!A\\\u0011\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]\u0006BQa]\u0003A\u0002Q\f\u0001\u0003]3s[&\u001c8/[8ogR{\u0017\t\u001a3\u0011\u0007UTxM\u0004\u0002wq:\u0011!n^\u0005\u0002E%\u0011\u00110I\u0001\ba\u0006\u001c7.Y4f\u0013\tYHP\u0001\u0003MSN$(BA=\"\u0011\u0015qX\u00011\u0001u\u0003I\u0001XM]7jgNLwN\u001c+p\t\u0016dW\r^3\u0002%I,Wn\u001c<f\r>\u0014(+\u001a4fe\u0016t7-\u001a\u000b\u0004+\u0006\r\u0001BBA\u0003\r\u0001\u0007Q,A\u0006sK\u001a,'/\u001a8dK&#\u0017!\u0003:f[>4X-\u00117m)\u0005)\u0016aD2iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\u0011\u0005=\u0011QCA\r\u00037\u00012\u0001IA\t\u0013\r\t\u0019\"\t\u0002\b\u0005>|G.Z1o\u0011\u0019\t9\u0002\u0003a\u00015\u0006q!/\u001a4fe\u0016t7-Z'bs\n,\u0007\"\u0002\f\t\u0001\u0004!\bBBA\u000f\u0011\u0001\u0007A/\u0001\u0005bY2\u0014v\u000e\\3tQ\rA\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\u000b\u0002\u0007)\u0004\u0018-\u0003\u0003\u0002,\u0005\u0015\"A\n*fC\u0012|e\u000e\\=Ue\u0006t7/Y2uS>t\u0017\r\u001c)fe6L7o]5p]N+'O^5dKRQ\u0011qBA\u0018\u0003c\t\u0019$!\u000e\t\r\u0005]\u0011\u00021\u0001[\u0011\u00151\u0012\u00021\u0001u\u0011\u0019\ti\"\u0003a\u0001i\"1\u0011qG\u0005A\u0002Q\f!\u0002\u001d:j]\u000eL\u0007/\u00197tQ\rI\u0011\u0011\u0005\u000b\t\u0003{\t\u0019%!\u0013\u0002LA1\u0001.a\u0010h\u0003\u001fI1!!\u0011r\u0005\ri\u0015\r\u001d\u0005\b\u0003\u000bR\u0001\u0019AA$\u0003)\u0011XMZ3sK:\u001cWm\u001d\t\u0004kjl\u0006\"\u0002\f\u000b\u0001\u0004!\bBBA\u000f\u0015\u0001\u0007A\u000fK\u0002\u000b\u0003C!\"\"!\u0010\u0002R\u0005M\u0013QKA,\u0011\u001d\t)e\u0003a\u0001\u0003\u000fBQAF\u0006A\u0002QDa!!\b\f\u0001\u0004!\bBBA\u001c\u0017\u0001\u0007A\u000fK\u0002\f\u0003C\t\u0001dZ3u\u00032d\u0007+\u001a:nSN\u001c\u0018n\u001c8t\r>\u0014(k\u001c7f)!\ty&a\u001d\u0002v\u0005}\u0004\u0003BA1\u0003_j!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0004IR|'\u0002BA5\u0003W\nAA]3ti*\u0019\u0011QN\u000b\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002r\u0005\r$A\u0006*pY\u0016<\u0016\u000e\u001e5QKJl\u0017n]:j_:\u001cH\t^8\t\u000b\u0019d\u0001\u0019A4\t\u000f\u0005]D\u00021\u0001\u0002z\u0005!\u0001/Y4f!\r\u0001\u00131P\u0005\u0004\u0003{\n#aA%oi\"9\u0011\u0011\u0011\u0007A\u0002\u0005e\u0014\u0001B:ju\u0016D3\u0001DA\u0011\u0003e9W\r^!mYB+'/\\5tg&|gn\u001d$peJ{G.Z:\u0015\u0011\u0005%\u0015qRAJ\u0003+\u0003RAJAF\u0003?J1!!$\u0014\u0005E\u0001\u0016mZ5oCR,GMU3ta>t7/\u001a\u0005\u0007\u0003#k\u0001\u0019\u0001;\u0002\u000b9\fW.Z:\t\u000f\u0005]T\u00021\u0001\u0002z!9\u0011\u0011Q\u0007A\u0002\u0005e\u0004fA\u0007\u0002\"Q!\u0011qLAN\u0011\u00151g\u00021\u0001hQ\rq\u0011\u0011\u0005\u000b\u0005\u0003C\u000b\u0019\u000b\u0005\u0003vu\u0006}\u0003BBAS\u001f\u0001\u0007A/A\u0005s_2,g*Y7fg\"\u001aq\"!\t)\u001f\u0001\tY+a0\u0002B\u0006\u001d\u0017\u0011ZAg\u0003\u001f\u0004B!!,\u0002<6\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0005d_:$\u0017\u000e^5p]*!\u0011QWA\\\u00035\tW\u000f^8d_:4\u0017nZ;sK*\u0019\u0011\u0011X\u001d\u0002\t\t|w\u000e^\u0005\u0005\u0003{\u000byKA\u000bD_:$\u0017\u000e^5p]\u0006dwJ\u001c)s_B,'\u000f^=\u0002\t9\fW.\u001a\u0017\u0003\u0003\u0007\f#!!2\u0002;adg\u0006]3s[&\u001c8/[8o[M,'O^5dK:*g.\u00192mK\u0012\f1\u0002[1wS:<g+\u00197vK\u0006\u0012\u00111Z\u0001\u0005iJ,X-\u0001\bnCR\u001c\u0007.\u00134NSN\u001c\u0018N\\4\u001a\u0003\u0005A3\u0001AAj!\u0011\t).a7\u000e\u0005\u0005]'bAAms\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005u\u0017q\u001b\u0002\b'\u0016\u0014h/[2fQ\u001d\u0001\u0011\u0011]Ax\u0003c\u0004B!a9\u0002l6\u0011\u0011Q\u001d\u0006\u0004i\u0005\u001d(bAAus\u000591m\u001c8uKb$\u0018\u0002BAw\u0003K\u0014q\u0001\u0015:pM&dW-A\u0003wC2,X\r\f\u0002\u0002t\u0006\u0012\u0011Q_\u0001\u0013a\u0016\u0014X.[:tS>tWf]3sm&\u001cW\rK\u0002\u0001\u0003s\u0004B!a\t\u0002|&!\u0011Q`A\u0013\u0005y!&/\u00198tC\u000e$\u0018n\u001c8bYB+'/\\5tg&|gnU3sm&\u001cW\r")
public class LocalPermissionsServiceClient
implements PermissionServiceClient {
    @Autowired
    private final GlobalPermissionService globalPermissionService;
    @Autowired
    private final ReferencedPermissionService referencedPermissionService;
    @Autowired
    private final RoleService roleService;

    @Override
    public void createOrUpdate(Option<UUID> referenceIdMaybe, String roleName, List<String> permissionsToAdd, List<String> permissionToDelete) {
        Option<UUID> option = referenceIdMaybe;
        if (option instanceof Some) {
            Some some = (Some)option;
            UUID referenceId = (UUID)some.value();
            Either either = this.referencedPermissionService.edit(referenceId, roleName, permissionsToAdd, permissionToDelete);
            if (either instanceof Left) {
                Left left = (Left)either;
                RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
                throw new RoleNameNotFoundException(exception.name());
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            return;
        }
        this.globalPermissionService.edit(roleName, permissionsToAdd, permissionToDelete);
    }

    @Override
    public void removeForReference(UUID referenceId) {
        this.referencedPermissionService.removeForReference(referenceId);
    }

    @Override
    public void removeAll() {
        this.referencedPermissionService.removeAll();
        this.globalPermissionService.removeAll();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(Option<UUID> referenceMaybe, List<String> permissions, List<String> allRoles) {
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, permissions, allRoles))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(permissions, allRoles)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(Option<UUID> referenceMaybe, List<String> permissions, List<String> allRoles, List<String> principals) {
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, permissions, allRoles, principals))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(permissions, allRoles, principals)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Map<String, Object> checkPermission(List<UUID> references, List<String> permissions, List<String> allRoles) {
        return references.map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, permissions, allRoles)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Map<String, Object> checkPermission(List<UUID> references, List<String> permissions, List<String> allRoles, List<String> principals) {
        return references.map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, permissions, allRoles, principals)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public RoleWithPermissionsDto getAllPermissionsForRole(String roleName, int page, int size) {
        return this.getAllPermissionsForRole(roleName);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public PaginatedResponse<RoleWithPermissionsDto> getAllPermissionsForRoles(List<String> names, int page, int size) {
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)size);
        Page roles = this.roleService.read(names, (Pageable)pageable);
        List roleNames = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)x$1 -> x$1.name());
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$2 -> x$2.role().name());
        Either either = this.referencedPermissionService.read(roleNames);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List result = (List)right.value();
        Map referencedPermissions = result.groupBy((Function1 & Serializable)x$3 -> x$3.role().name());
        List dtos = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$4 -> x$4.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$5 -> x$5.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
        return new PaginatedResponse<RoleWithPermissionsDto>(dtos, roles.getTotalElements(), page, size, roles.hasNext());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public RoleWithPermissionsDto getAllPermissionsForRole(String roleName) {
        List globalPermissions = this.globalPermissionService.read(roleName).map((Function1 & Serializable)x$6 -> x$6.permissionName());
        Either either = this.referencedPermissionService.read(roleName);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List result = (List)right.value();
        Map referencedPermissions = result.groupBy((Function1 & Serializable)x$7 -> x$7.reference());
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        List referencedPermissionsDto = ((IterableOnceOps)referencedPermissions.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$8 -> x$8.permissionName())))).toList();
        return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), globalPermissions, referencedPermissionsDto);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<RoleWithPermissionsDto> getAllPermissionsForRoles(List<String> roleNames) {
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$9 -> x$9.role().name());
        Either either = this.referencedPermissionService.read(roleNames);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List permissions = (List)right.value();
        Map referencedPermissions = permissions.groupBy((Function1 & Serializable)x$10 -> x$10.role().name());
        Either either2 = this.roleService.read(roleNames);
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either2 instanceof Right) {
            Right right2 = (Right)either2;
            List roles = (List)right2.value();
            return roles.map((Function1 & Serializable)role -> {
                Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$11 -> x$11.reference());
                List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$12 -> x$12.permissionName())))).toList();
                return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
            });
        }
        throw new MatchError((Object)either2);
    }

    public LocalPermissionsServiceClient(@Autowired GlobalPermissionService globalPermissionService, @Autowired ReferencedPermissionService referencedPermissionService, @Autowired RoleService roleService) {
        this.globalPermissionService = globalPermissionService;
        this.referencedPermissionService = referencedPermissionService;
        this.roleService = roleService;
    }
}

