/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.configuration.git;

import com.xebialabs.deployit.plugin.stitch.configuration.git.GitAuthenticationStrategy;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.engine.util.SourceUtils$;
import java.io.File;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.transport.RefSpec;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.util.matching.Regex;

public final class UsernameAndPasswordAuthenticationStrategy$
implements GitAuthenticationStrategy {
    public static final UsernameAndPasswordAuthenticationStrategy$ MODULE$ = new UsernameAndPasswordAuthenticationStrategy$();
    private static final Regex httpUrlRegex;

    static {
        GitAuthenticationStrategy.$init$(MODULE$);
        httpUrlRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(http(s)?)(:(//)?)([\\w\\.@\\:/\\-~]+)(\\.git)?(/)?$"));
    }

    @Override
    public CloneCommand cloneRepoWithAuthentication(GitSource source, File configRoot) {
        return GitAuthenticationStrategy.cloneRepoWithAuthentication$(this, source, configRoot);
    }

    @Override
    public boolean hasUsernameAndPassword(GitUserCredentials credentials, String url) {
        return GitAuthenticationStrategy.hasUsernameAndPassword$(this, credentials, url);
    }

    @Override
    public void pushWithAuthentication(Git git, GitSource gitSource, File configRoot, List<RefSpec> refSpecs) {
        GitAuthenticationStrategy.pushWithAuthentication$(this, git, gitSource, configRoot, refSpecs);
    }

    public Regex httpUrlRegex() {
        return httpUrlRegex;
    }

    @Override
    public boolean matches(GitUserCredentials credentials, String url) {
        return this.hasUsernameAndPassword(credentials, url) && this.httpUrlRegex().pattern().matcher(url).matches();
    }

    @Override
    public CloneCommand cloneRepoWithAuthentication(GitUserCredentials credentials, GitSource source, File configRoot) {
        return (CloneCommand)GitAuthenticationStrategy.cloneRepoWithAuthentication$(this, credentials, source, configRoot).setCredentialsProvider(SourceUtils$.MODULE$.getCredentialsProvider(credentials));
    }

    @Override
    public void pushWithAuthentication(Git git, GitUserCredentials credentials, File configRoot, List<RefSpec> refSpecs) {
        ((PushCommand)git.push().setRefSpecs(CollectionConverters$.MODULE$.SeqHasAsJava(refSpecs).asJava()).setCredentialsProvider(SourceUtils$.MODULE$.getCredentialsProvider(credentials.username(), credentials.password()))).call();
    }

    @Override
    public LsRemoteCommand listWithAuthentication(GitUserCredentials credentials, String repositoryUrl, File configRoot) {
        return (LsRemoteCommand)GitAuthenticationStrategy.listWithAuthentication$(this, credentials, repositoryUrl, configRoot).setCredentialsProvider(SourceUtils$.MODULE$.getCredentialsProvider(credentials));
    }

    private UsernameAndPasswordAuthenticationStrategy$() {
    }
}

