/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.ha;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;

public class SharedStoreBackupPolicyConfiguration
implements HAPolicyConfiguration {
    private boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean restartBackup = ActiveMQDefaultConfiguration.isDefaultRestartBackup();
    private boolean allowFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private ScaleDownConfiguration scaleDownConfiguration;

    @Override
    public HAPolicyConfiguration.TYPE getType() {
        return HAPolicyConfiguration.TYPE.SHARED_STORE_BACKUP;
    }

    public boolean isRestartBackup() {
        return this.restartBackup;
    }

    public SharedStoreBackupPolicyConfiguration setRestartBackup(boolean restartBackup) {
        this.restartBackup = restartBackup;
        return this;
    }

    public ScaleDownConfiguration getScaleDownConfiguration() {
        return this.scaleDownConfiguration;
    }

    public SharedStoreBackupPolicyConfiguration setScaleDownConfiguration(ScaleDownConfiguration scaleDownConfiguration) {
        this.scaleDownConfiguration = scaleDownConfiguration;
        return this;
    }

    public boolean isAllowFailBack() {
        return this.allowFailBack;
    }

    public SharedStoreBackupPolicyConfiguration setAllowFailBack(boolean allowFailBack) {
        this.allowFailBack = allowFailBack;
        return this;
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public SharedStoreBackupPolicyConfiguration setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        return this;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public SharedStoreBackupPolicyConfiguration setFailbackDelay(long failbackDelay) {
        return this;
    }
}

