/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.java.decompiler.main.DecompilerContext;

public class ExceptionHandler {
    public int from = 0;
    public int to = 0;
    public int handler = 0;
    public int from_instr = 0;
    public int to_instr = 0;
    public int handler_instr = 0;
    public int class_index = 0;
    public String exceptionClass = null;

    public ExceptionHandler() {
    }

    public ExceptionHandler(int from_raw, int to_raw, int handler_raw, String exceptionClass) {
        this.from = from_raw;
        this.to = to_raw;
        this.handler = handler_raw;
        this.exceptionClass = exceptionClass;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(this.from);
        out.writeShort(this.to);
        out.writeShort(this.handler);
        out.writeShort(this.class_index);
    }

    public String toString() {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        return "from: " + this.from + " to: " + this.to + " handler: " + this.handler + new_line_separator + "from_instr: " + this.from_instr + " to_instr: " + this.to_instr + " handler_instr: " + this.handler_instr + new_line_separator + "exceptionClass: " + this.exceptionClass + new_line_separator;
    }
}

