/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.rest;

import com.google.common.io.CharStreams;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class RequestExecutor {
    private final DeployitCommunicator communicator;

    public RequestExecutor(DeployitCommunicator communicator) {
        this.communicator = communicator;
    }

    public String execute(HttpUriRequest req) {
        try {
            HttpResponse response = this.communicator.execute(req);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return this.getContent(response);
            }
            if (statusCode == 204) {
                return response.toString();
            }
            StringBuilder errorMessage = new StringBuilder(response.getStatusLine().getReasonPhrase());
            try {
                String responseContent = this.getContent(response);
                if (!responseContent.isEmpty()) {
                    errorMessage.append(": ").append(responseContent);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new RuntimeException(errorMessage.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getContent(HttpResponse response) {
        try (InputStream content = response.getEntity().getContent();){
            String string;
            try (InputStreamReader is = new InputStreamReader(content);){
                string = CharStreams.toString((Readable)is);
            }
            return string;
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

