/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.security.reactive.ApplicationContextServerWebExchangeMatcher;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class EndpointRequest {
    private static final ServerWebExchangeMatcher EMPTY_MATCHER = request -> ServerWebExchangeMatcher.MatchResult.notMatch();

    private EndpointRequest() {
    }

    public static EndpointServerWebExchangeMatcher toAnyEndpoint() {
        return new EndpointServerWebExchangeMatcher(true);
    }

    public static EndpointServerWebExchangeMatcher to(Class<?> ... endpoints) {
        return new EndpointServerWebExchangeMatcher(endpoints, false);
    }

    public static EndpointServerWebExchangeMatcher to(String ... endpoints) {
        return new EndpointServerWebExchangeMatcher(endpoints, false);
    }

    public static LinksServerWebExchangeMatcher toLinks() {
        return new LinksServerWebExchangeMatcher();
    }

    public static AdditionalPathsEndpointServerWebExchangeMatcher toAdditionalPaths(WebServerNamespace webServerNamespace, Class<?> ... endpoints) {
        return new AdditionalPathsEndpointServerWebExchangeMatcher(webServerNamespace, endpoints);
    }

    public static AdditionalPathsEndpointServerWebExchangeMatcher toAdditionalPaths(WebServerNamespace webServerNamespace, String ... endpoints) {
        return new AdditionalPathsEndpointServerWebExchangeMatcher(webServerNamespace, endpoints);
    }

    public static final class EndpointServerWebExchangeMatcher
    extends AbstractWebExchangeMatcher<PathMappedEndpoints> {
        private final List<Object> includes;
        private final List<Object> excludes;
        private final boolean includeLinks;

        private EndpointServerWebExchangeMatcher(boolean includeLinks) {
            this(Collections.emptyList(), Collections.emptyList(), includeLinks);
        }

        private EndpointServerWebExchangeMatcher(Class<?>[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointServerWebExchangeMatcher(String[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointServerWebExchangeMatcher(List<Object> includes, List<Object> excludes, boolean includeLinks) {
            super(PathMappedEndpoints.class);
            this.includes = includes;
            this.excludes = excludes;
            this.includeLinks = includeLinks;
        }

        public EndpointServerWebExchangeMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointServerWebExchangeMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointServerWebExchangeMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointServerWebExchangeMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointServerWebExchangeMatcher excludingLinks() {
            return new EndpointServerWebExchangeMatcher(this.includes, this.excludes, false);
        }

        @Override
        protected ServerWebExchangeMatcher createDelegate(PathMappedEndpoints endpoints) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (this.includes.isEmpty()) {
                paths.addAll(endpoints.getAllPaths());
            }
            this.streamPaths(this.includes, endpoints).forEach(paths::add);
            this.streamPaths(this.excludes, endpoints).forEach(paths::remove);
            List<ServerWebExchangeMatcher> delegateMatchers = this.getDelegateMatchers(paths);
            if (this.includeLinks && StringUtils.hasText((String)endpoints.getBasePath())) {
                delegateMatchers.add((ServerWebExchangeMatcher)new LinksServerWebExchangeMatcher());
            }
            return new OrServerWebExchangeMatcher(delegateMatchers);
        }

        private Stream<String> streamPaths(List<Object> source, PathMappedEndpoints endpoints) {
            return source.stream().filter(Objects::nonNull).map(this::getEndpointId).map(arg_0 -> ((PathMappedEndpoints)endpoints).getPath(arg_0));
        }

        public String toString() {
            return String.format("EndpointRequestMatcher includes=%s, excludes=%s, includeLinks=%s", this.toString(this.includes, "[*]"), this.toString(this.excludes, "[]"), this.includeLinks);
        }
    }

    public static final class LinksServerWebExchangeMatcher
    extends AbstractWebExchangeMatcher<WebEndpointProperties> {
        private LinksServerWebExchangeMatcher() {
            super(WebEndpointProperties.class);
        }

        @Override
        protected ServerWebExchangeMatcher createDelegate(WebEndpointProperties properties) {
            if (StringUtils.hasText((String)properties.getBasePath())) {
                return new OrServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{new PathPatternParserServerWebExchangeMatcher(properties.getBasePath()), new PathPatternParserServerWebExchangeMatcher(properties.getBasePath() + "/")});
            }
            return EMPTY_MATCHER;
        }

        public String toString() {
            return String.format("LinksServerWebExchangeMatcher", new Object[0]);
        }
    }

    public static class AdditionalPathsEndpointServerWebExchangeMatcher
    extends AbstractWebExchangeMatcher<PathMappedEndpoints> {
        private final WebServerNamespace webServerNamespace;
        private final List<Object> endpoints;

        AdditionalPathsEndpointServerWebExchangeMatcher(WebServerNamespace webServerNamespace, String ... endpoints) {
            this(webServerNamespace, Arrays.asList((Object[])endpoints));
        }

        AdditionalPathsEndpointServerWebExchangeMatcher(WebServerNamespace webServerNamespace, Class<?> ... endpoints) {
            this(webServerNamespace, Arrays.asList((Object[])endpoints));
        }

        private AdditionalPathsEndpointServerWebExchangeMatcher(WebServerNamespace webServerNamespace, List<Object> endpoints) {
            super(PathMappedEndpoints.class);
            Assert.notNull((Object)webServerNamespace, (String)"'webServerNamespace' must not be null");
            Assert.notNull(endpoints, (String)"'endpoints' must not be null");
            Assert.notEmpty(endpoints, (String)"'endpoints' must not be empty");
            this.webServerNamespace = webServerNamespace;
            this.endpoints = endpoints;
        }

        @Override
        protected boolean ignoreApplicationContext(ApplicationContext applicationContext, ManagementPortType managementPortType) {
            return !this.hasWebServerNamespace(applicationContext, this.webServerNamespace);
        }

        @Override
        protected ServerWebExchangeMatcher createDelegate(PathMappedEndpoints endpoints) {
            Set paths = this.endpoints.stream().filter(Objects::nonNull).map(this::getEndpointId).flatMap(endpointId -> this.streamAdditionalPaths(endpoints, (EndpointId)endpointId)).collect(Collectors.toCollection(LinkedHashSet::new));
            List<ServerWebExchangeMatcher> delegateMatchers = this.getDelegateMatchers(paths);
            return !CollectionUtils.isEmpty(delegateMatchers) ? new OrServerWebExchangeMatcher(delegateMatchers) : EMPTY_MATCHER;
        }

        private Stream<String> streamAdditionalPaths(PathMappedEndpoints pathMappedEndpoints, EndpointId endpointId) {
            return pathMappedEndpoints.getAdditionalPaths(this.webServerNamespace, endpointId).stream();
        }

        public String toString() {
            return String.format("AdditionalPathsEndpointServerWebExchangeMatcher endpoints=%s, webServerNamespace=%s", this.toString(this.endpoints, ""), this.webServerNamespace);
        }
    }

    private static abstract class AbstractWebExchangeMatcher<C>
    extends ApplicationContextServerWebExchangeMatcher<C> {
        private volatile ServerWebExchangeMatcher delegate;
        private volatile ManagementPortType managementPortType;

        AbstractWebExchangeMatcher(Class<? extends C> contextClass) {
            super(contextClass);
        }

        protected void initialized(Supplier<C> supplier) {
            this.delegate = this.createDelegate((C)supplier);
        }

        private ServerWebExchangeMatcher createDelegate(Supplier<C> context) {
            try {
                return this.createDelegate(context.get());
            }
            catch (NoSuchBeanDefinitionException ex) {
                return EMPTY_MATCHER;
            }
        }

        protected abstract ServerWebExchangeMatcher createDelegate(C var1);

        protected final List<ServerWebExchangeMatcher> getDelegateMatchers(Set<String> paths) {
            return paths.stream().map(this::getDelegateMatcher).collect(Collectors.toCollection(ArrayList::new));
        }

        private PathPatternParserServerWebExchangeMatcher getDelegateMatcher(String path) {
            return new PathPatternParserServerWebExchangeMatcher(path + "/**");
        }

        protected Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange, Supplier<C> context) {
            return this.delegate.matches(exchange);
        }

        protected boolean ignoreApplicationContext(ApplicationContext applicationContext) {
            ManagementPortType managementPortType = this.managementPortType;
            if (managementPortType == null) {
                this.managementPortType = managementPortType = ManagementPortType.get(applicationContext.getEnvironment());
            }
            return this.ignoreApplicationContext(applicationContext, managementPortType);
        }

        protected boolean ignoreApplicationContext(ApplicationContext applicationContext, ManagementPortType managementPortType) {
            return managementPortType == ManagementPortType.DIFFERENT && !this.hasWebServerNamespace(applicationContext, WebServerNamespace.MANAGEMENT);
        }

        protected final boolean hasWebServerNamespace(ApplicationContext applicationContext, WebServerNamespace webServerNamespace) {
            return WebServerApplicationContext.hasServerNamespace((ApplicationContext)applicationContext, (String)webServerNamespace.getValue()) || this.hasImplicitServerNamespace(applicationContext, webServerNamespace);
        }

        private boolean hasImplicitServerNamespace(ApplicationContext applicationContext, WebServerNamespace webServerNamespace) {
            return WebServerNamespace.SERVER.equals((Object)webServerNamespace) && WebServerApplicationContext.getServerNamespace((ApplicationContext)applicationContext) == null && applicationContext.getParent() == null;
        }

        protected final String toString(List<Object> endpoints, String emptyValue) {
            return !endpoints.isEmpty() ? endpoints.stream().map(this::getEndpointId).map(Object::toString).collect(Collectors.joining(", ", "[", "]")) : emptyValue;
        }

        protected final EndpointId getEndpointId(Object source) {
            if (source instanceof EndpointId) {
                EndpointId endpointId = (EndpointId)source;
                return endpointId;
            }
            if (source instanceof String) {
                String string = (String)source;
                return EndpointId.of((String)string);
            }
            if (source instanceof Class) {
                return this.getEndpointId((Class)source);
            }
            throw new IllegalStateException("Unsupported source " + String.valueOf(source));
        }

        private EndpointId getEndpointId(Class<?> source) {
            MergedAnnotation annotation = MergedAnnotations.from(source).get(Endpoint.class);
            Assert.state((boolean)annotation.isPresent(), () -> "Class " + String.valueOf(source) + " is not annotated with @Endpoint");
            return EndpointId.of((String)annotation.getString("id"));
        }
    }
}

