/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

abstract class AbstractUnmodifiableCollectionDeserializer<T>
extends JsonDeserializer<T> {
    AbstractUnmodifiableCollectionDeserializer() {
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        ArrayList<Object> values = new ArrayList<Object>();
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode elementNode : arrayNode) {
                values.add(mapper.readValue(elementNode.traverse((ObjectCodec)mapper), Object.class));
            }
        } else if (node != null) {
            values.add(mapper.readValue(node.traverse((ObjectCodec)mapper), Object.class));
        }
        return this.createUnmodifiableCollection(values);
    }

    abstract T createUnmodifiableCollection(Collection<Object> var1) throws IOException;
}

