/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.SimpleAsyncInvocationStage;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.PendingLockListener;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.concurrent.locks.PendingLockPromise;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultPendingLockManager
implements PendingLockManager {
    private static final Log log = LogFactory.getLog(DefaultPendingLockManager.class);
    private static final int NO_PENDING_CHECK = -2;
    @Inject
    TransactionTable transactionTable;
    @Inject
    TimeService timeService;
    @Inject
    DistributionManager distributionManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService timeoutExecutor;

    @Override
    public PendingLockPromise checkPendingTransactionsForKey(TxInvocationContext<?> ctx, Object key, long time, TimeUnit unit) {
        GlobalTransaction globalTransaction = ctx.getGlobalTransaction();
        int txTopologyId = this.getTopologyId(ctx);
        if (txTopologyId == -2) {
            if (log.isTraceEnabled()) {
                log.tracef("Skipping pending transactions check for transaction %s", globalTransaction);
            }
            return PendingLockPromise.NO_OP;
        }
        return this.createPromise(this.getTransactionWithLockedKey(txTopologyId, key, globalTransaction), globalTransaction, time, unit);
    }

    @Override
    public PendingLockPromise checkPendingTransactionsForKeys(TxInvocationContext<?> ctx, Collection<Object> keys, long time, TimeUnit unit) {
        GlobalTransaction globalTransaction = ctx.getGlobalTransaction();
        int txTopologyId = this.getTopologyId(ctx);
        if (txTopologyId == -2) {
            if (log.isTraceEnabled()) {
                log.tracef("Skipping pending transactions check for transaction %s", globalTransaction);
            }
            return PendingLockPromise.NO_OP;
        }
        return this.createPromise(this.getTransactionWithAnyLockedKey(txTopologyId, keys, globalTransaction), globalTransaction, time, unit);
    }

    @Override
    public long awaitPendingTransactionsForKey(TxInvocationContext<?> ctx, Object key, long time, TimeUnit unit) throws InterruptedException {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        PendingLockPromise pendingLockPromise = this.checkPendingTransactionsForKey(ctx, key, time, unit);
        if (log.isTraceEnabled()) {
            log.tracef("Await for pending transactions for transaction %s using %s", gtx, pendingLockPromise);
        }
        return DefaultPendingLockManager.awaitOn(pendingLockPromise, gtx, time, unit);
    }

    @Override
    public long awaitPendingTransactionsForAllKeys(TxInvocationContext<?> ctx, Collection<Object> keys, long time, TimeUnit unit) throws InterruptedException {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        PendingLockPromise pendingLockPromise = this.checkPendingTransactionsForKeys(ctx, keys, time, unit);
        if (log.isTraceEnabled()) {
            log.tracef("Await for pending transactions for transaction %s using %s", gtx, pendingLockPromise);
        }
        return DefaultPendingLockManager.awaitOn(pendingLockPromise, gtx, time, unit);
    }

    private PendingLockPromise createPromise(Collection<PendingTransaction> transactions, GlobalTransaction globalTransaction, long time, TimeUnit unit) {
        if (transactions.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.tracef("No transactions pending for transaction %s", globalTransaction);
            }
            return PendingLockPromise.NO_OP;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Transactions pending for transaction %s are %s", globalTransaction, transactions);
        }
        PendingLockPromiseImpl pendingLockPromise = new PendingLockPromiseImpl(globalTransaction, time, unit, transactions);
        pendingLockPromise.scheduleTimeoutTask();
        pendingLockPromise.registerListenerInCacheTransactions();
        return pendingLockPromise;
    }

    private int getTopologyId(TxInvocationContext<?> context) {
        int topologyId;
        boolean isFromStateTransfer;
        Object tx = context.getCacheTransaction();
        boolean bl = isFromStateTransfer = context.isOriginLocal() && ((LocalTransaction)tx).isFromStateTransfer();
        if (!isFromStateTransfer && (topologyId = this.distributionManager.getCacheTopology().getTopologyId()) != -1 && this.transactionTable.getMinTopologyId() < topologyId) {
            return topologyId;
        }
        return -2;
    }

    private static TimeoutException timeout(KeyValuePair<CacheTransaction, Object> lockOwner, GlobalTransaction thisGlobalTransaction, long timeout, TimeUnit timeUnit) {
        return log.unableToAcquireLock(Util.prettyPrintTime((long)timeout, (TimeUnit)timeUnit), lockOwner.getValue(), thisGlobalTransaction, String.valueOf(lockOwner.getKey().getGlobalTransaction()) + " (pending)");
    }

    private Collection<PendingTransaction> getTransactionWithLockedKey(int transactionTopologyId, Object key, GlobalTransaction globalTransaction) {
        if (key == null) {
            return Collections.emptyList();
        }
        ArrayList pendingTransactions = new ArrayList();
        this.forEachTransaction(transaction -> {
            CompletableFuture<Void> keyReleasedFuture;
            if (transaction.getTopologyId() < transactionTopologyId && !transaction.getGlobalTransaction().equals(globalTransaction) && (keyReleasedFuture = transaction.getReleaseFutureForKey(key)) != null) {
                pendingTransactions.add(new PendingTransaction((CacheTransaction)transaction, Collections.singletonMap(key, keyReleasedFuture)));
            }
        });
        return pendingTransactions.isEmpty() ? Collections.emptyList() : pendingTransactions;
    }

    private Collection<PendingTransaction> getTransactionWithAnyLockedKey(int transactionTopologyId, Collection<Object> keys, GlobalTransaction globalTransaction) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList pendingTransactions = new ArrayList();
        this.forEachTransaction(transaction -> {
            Map<Object, CompletableFuture<Void>> keyReleaseFuture;
            if (transaction.getTopologyId() < transactionTopologyId && !transaction.getGlobalTransaction().equals(globalTransaction) && (keyReleaseFuture = transaction.getReleaseFutureForKeys(keys)) != null) {
                pendingTransactions.add(new PendingTransaction((CacheTransaction)transaction, keyReleaseFuture));
            }
        });
        return pendingTransactions.isEmpty() ? Collections.emptyList() : pendingTransactions;
    }

    private void forEachTransaction(Consumer<CacheTransaction> consumer) {
        Collection<LocalTransaction> localTransactions = this.transactionTable.getLocalTransactions();
        Collection<RemoteTransaction> remoteTransactions = this.transactionTable.getRemoteTransactions();
        int totalSize = localTransactions.size() + remoteTransactions.size();
        if (totalSize == 0) {
            return;
        }
        if (!localTransactions.isEmpty()) {
            localTransactions.forEach(consumer);
        }
        if (!remoteTransactions.isEmpty()) {
            remoteTransactions.forEach(consumer);
        }
    }

    private static long awaitOn(PendingLockPromise pendingLockPromise, GlobalTransaction globalTransaction, long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (pendingLockPromise == PendingLockPromise.NO_OP) {
            return timeUnit.toMillis(timeout);
        }
        assert (pendingLockPromise instanceof PendingLockPromiseImpl);
        ((PendingLockPromiseImpl)pendingLockPromise).await();
        return pendingLockPromise.getRemainingTimeout();
    }

    private class PendingLockPromiseImpl
    implements PendingLockPromise,
    Callable<Void>,
    Runnable {
        private final GlobalTransaction globalTransaction;
        private final long timeoutNanos;
        private final Collection<PendingTransaction> pendingTransactions;
        private final long expectedEndTime;
        private final CompletableFuture<Void> notifier;
        private ScheduledFuture<Void> timeoutTask;

        private PendingLockPromiseImpl(GlobalTransaction globalTransaction, long timeout, TimeUnit timeUnit, Collection<PendingTransaction> pendingTransactions) {
            this.globalTransaction = globalTransaction;
            this.timeoutNanos = timeUnit.toNanos(timeout);
            this.pendingTransactions = pendingTransactions;
            this.expectedEndTime = DefaultPendingLockManager.this.timeService.expectedEndTime(this.timeoutNanos, TimeUnit.NANOSECONDS);
            this.notifier = new CompletableFuture();
        }

        @Override
        public InvocationStage toInvocationStage() {
            return new SimpleAsyncInvocationStage(this.notifier);
        }

        @Override
        public boolean isReady() {
            return this.notifier.isDone();
        }

        @Override
        public void addListener(PendingLockListener listener) {
            this.notifier.whenComplete((v, throwable) -> listener.onReady());
        }

        @Override
        public boolean hasTimedOut() {
            return this.notifier.isCompletedExceptionally();
        }

        @Override
        public long getRemainingTimeout() {
            return DefaultPendingLockManager.this.timeService.remainingTime(this.expectedEndTime, TimeUnit.MILLISECONDS);
        }

        @Override
        public Void call() throws Exception {
            this.onRelease();
            return null;
        }

        @Override
        public void run() {
            this.onRelease();
        }

        private void onRelease() {
            KeyValuePair<CacheTransaction, Object> timedOutTransaction = null;
            for (PendingTransaction transaction : this.pendingTransactions) {
                KeyValuePair<CacheTransaction, Object> waiting = transaction.findUnreleasedKey();
                if (waiting == null) continue;
                if (DefaultPendingLockManager.this.timeService.isTimeExpired(this.expectedEndTime)) {
                    timedOutTransaction = waiting;
                    break;
                }
                return;
            }
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            if (timedOutTransaction == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("All pending transactions have finished for transaction %s", this.globalTransaction);
                }
                this.notifier.complete(null);
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("Timed out waiting for pending transaction %s for transaction %s", timedOutTransaction, this.globalTransaction);
                }
                this.notifier.completeExceptionally((Throwable)((Object)DefaultPendingLockManager.timeout(timedOutTransaction, this.globalTransaction, this.timeoutNanos, TimeUnit.NANOSECONDS)));
            }
        }

        void registerListenerInCacheTransactions() {
            for (PendingTransaction transaction : this.pendingTransactions) {
                transaction.afterCompleted(this);
            }
            this.onRelease();
        }

        void scheduleTimeoutTask() {
            if (!this.notifier.isDone()) {
                this.timeoutTask = DefaultPendingLockManager.this.timeoutExecutor.schedule(this, this.timeoutNanos, TimeUnit.NANOSECONDS);
            }
        }

        void await() throws InterruptedException {
            try {
                this.notifier.get(DefaultPendingLockManager.this.timeService.remainingTime(this.expectedEndTime, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Should never happen.", e);
            }
            catch (java.util.concurrent.TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    private static class PendingTransaction {
        private final CacheTransaction cacheTransaction;
        private final Map<Object, CompletableFuture<Void>> keyReleased;

        private PendingTransaction(CacheTransaction cacheTransaction, Map<Object, CompletableFuture<Void>> keyReleased) {
            this.cacheTransaction = cacheTransaction;
            this.keyReleased = keyReleased;
        }

        public String toString() {
            return "PendingTransaction{gtx=" + this.cacheTransaction.getGlobalTransaction().globalId() + ", keys=" + String.valueOf(this.keyReleased.keySet()) + "}";
        }

        void afterCompleted(Runnable runnable) {
            this.keyReleased.values().forEach(voidCompletableFuture -> voidCompletableFuture.thenRun(runnable));
        }

        KeyValuePair<CacheTransaction, Object> findUnreleasedKey() {
            for (Map.Entry<Object, CompletableFuture<Void>> entry : this.keyReleased.entrySet()) {
                if (entry.getValue().isDone()) continue;
                return new KeyValuePair<CacheTransaction, Object>(this.cacheTransaction, entry.getKey());
            }
            return null;
        }
    }
}

