/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import org.springframework.boot.logging.logback.SpringProfileModel;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.util.StringUtils;

class SpringProfileModelHandler
extends ModelHandlerBase {
    private final Environment environment;

    SpringProfileModelHandler(Context context, Environment environment) {
        super(context);
        this.environment = environment;
    }

    public void handle(ModelInterpretationContext intercon, Model model) throws ModelHandlerException {
        SpringProfileModel profileModel = (SpringProfileModel)model;
        if (!this.acceptsProfiles(intercon, profileModel)) {
            model.deepMarkAsSkipped();
        }
    }

    private boolean acceptsProfiles(ModelInterpretationContext ic, SpringProfileModel model) {
        if (this.environment == null) {
            return false;
        }
        String[] profileNames = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)model.getName()));
        if (profileNames.length == 0) {
            return false;
        }
        for (int i = 0; i < profileNames.length; ++i) {
            try {
                profileNames[i] = OptionHelper.substVars((String)profileNames[i], (PropertyContainer)ic, (PropertyContainer)this.context);
                continue;
            }
            catch (ScanException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.environment.acceptsProfiles(Profiles.of((String[])profileNames));
    }
}

