/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.SortedSet;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.BasicCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class SortedSetCollectionInitializor
extends BasicCollectionInitializor<SortedSet> {
    private final Comparator comparator;

    public SortedSetCollectionInitializor(EnversService enversService, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, boolean removed, Class<? extends SortedSet> collectionClass, MiddleComponentData elementComponentData, Comparator comparator) {
        super(enversService, versionsReader, queryGenerator, primaryKey, revision, removed, collectionClass, elementComponentData);
        this.comparator = comparator;
    }

    @Override
    protected SortedSet initializeCollection(int size) {
        if (this.comparator == null) {
            return (SortedSet)super.initializeCollection(size);
        }
        return this.doPrivileged(() -> {
            try {
                return (SortedSet)this.collectionClass.getConstructor(Comparator.class).newInstance(this.comparator);
            }
            catch (InstantiationException e) {
                throw new AuditException(e);
            }
            catch (IllegalAccessException e) {
                throw new AuditException(e);
            }
            catch (NoSuchMethodException e) {
                throw new AuditException(e);
            }
            catch (InvocationTargetException e) {
                throw new AuditException(e);
            }
        });
    }
}

