/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.internal.util.StringHelper;

public final class ThreeEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final MiddleIdData referencedIdData;
    private final MiddleIdData indexIdData;
    private final MiddleComponentData[] componentDatas;

    public ThreeEntityQueryGenerator(Configuration configuration, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, MiddleIdData indexIdData, boolean revisionTypeInId, String orderByCollectionRole, MiddleComponentData ... componentData) {
        super(configuration, versionsMiddleEntityName, referencingIdData, revisionTypeInId, orderByCollectionRole);
        this.referencedIdData = referencedIdData;
        this.indexIdData = indexIdData;
        this.componentDatas = componentData;
    }

    @Override
    protected QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor sessionFactory) {
        String originalIdPropertyName = this.configuration.getOriginalIdPropertyName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        QueryBuilder qb = new QueryBuilder(this.entityName, "ee__", sessionFactory);
        qb.addFrom(this.referencedIdData.getAuditEntityName(), "e__", false);
        qb.addFrom(this.indexIdData.getAuditEntityName(), "f__", false);
        qb.addProjection("new list", "ee__, e__, f__", null, false);
        Parameters rootParameters = qb.getRootParameters();
        this.referencedIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, this.referencedIdData.getOriginalMapper(), "e__." + originalIdPropertyName);
        this.indexIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, this.indexIdData.getOriginalMapper(), "f__." + originalIdPropertyName);
        this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        if (!StringHelper.isEmpty((String)this.orderByCollectionRole)) {
            qb.addOrderFragment("e__", this.orderByCollectionRole);
        }
        return qb;
    }

    @Override
    protected void applyValidPredicates(QueryBuilder qb, Parameters rootParameters, boolean inclusive) {
        String revisionPropertyPath = this.configuration.getRevisionNumberPath();
        String originalIdPropertyName = this.configuration.getOriginalIdPropertyName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        String revisionTypePropName = this.getRevisionTypePath();
        this.auditStrategy.addEntityAtRevisionRestriction(this.configuration, qb, rootParameters, "e__." + revisionPropertyPath, "e__." + this.configuration.getRevisionEndFieldName(), false, this.referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", true);
        this.auditStrategy.addEntityAtRevisionRestriction(this.configuration, qb, rootParameters, "f__." + revisionPropertyPath, "f__." + this.configuration.getRevisionEndFieldName(), false, this.indexIdData, revisionPropertyPath, originalIdPropertyName, "f__", "f2__", true);
        this.auditStrategy.addAssociationAtRevisionRestriction(qb, rootParameters, revisionPropertyPath, this.configuration.getRevisionEndFieldName(), true, this.referencingIdData, this.entityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, "ee__", inclusive, this.componentDatas);
        rootParameters.addWhereWithNamedParam(revisionTypePropName, "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("e__." + revisionTypePropName, false, "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("f__." + revisionTypePropName, false, "!=", "delrevisiontype");
    }

    @Override
    protected void applyValidAndRemovePredicates(QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        String revisionPropertyPath = this.configuration.getRevisionNumberPath();
        String revisionTypePropName = this.getRevisionTypePath();
        this.applyValidPredicates(remQb, valid, false);
        removed.addWhereWithNamedParam(revisionPropertyPath, "=", "revision");
        removed.addWhereWithNamedParam("e__." + revisionPropertyPath, false, "=", "revision");
        removed.addWhereWithNamedParam("f__." + revisionPropertyPath, false, "=", "revision");
        removed.addWhereWithNamedParam(revisionTypePropName, "=", "delrevisiontype");
        removed.addWhereWithNamedParam("e__." + revisionTypePropName, false, "=", "delrevisiontype");
        removed.addWhereWithNamedParam("f__." + revisionTypePropName, false, "=", "delrevisiontype");
    }
}

