/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.io;

import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.io.BufferByteChunkProvider;
import com.hierynomus.smbj.io.ByteChunkProvider;
import java.io.IOException;

abstract class CachingByteChunkProvider
extends ByteChunkProvider {
    private BufferByteChunkProvider cachingProvider;
    private Buffer<Buffer.PlainBuffer> buffer = new Buffer.PlainBuffer(Endian.BE);

    CachingByteChunkProvider() {
        this.cachingProvider = new BufferByteChunkProvider(this.buffer);
    }

    @Override
    public void prepareWrite(int maxBytesToPrepare) {
        if (this.buffer == null) {
            return;
        }
        byte[] chunk = new byte[1024];
        this.buffer.compact();
        try {
            int read;
            for (int bytesNeeded = maxBytesToPrepare - this.buffer.available(); bytesNeeded > 0 && (read = this.prepareChunk(chunk, bytesNeeded)) != -1; bytesNeeded -= read) {
                this.buffer.putRawBytes(chunk, 0, read);
            }
        }
        catch (IOException e) {
            throw new SMBRuntimeException(e);
        }
    }

    abstract int prepareChunk(byte[] var1, int var2) throws IOException;

    @Override
    protected int getChunk(byte[] chunk) throws IOException {
        return this.cachingProvider.getChunk(chunk);
    }

    @Override
    public int bytesLeft() {
        return this.cachingProvider.bytesLeft();
    }

    @Override
    public boolean isAvailable() {
        return this.cachingProvider.isAvailable();
    }

    @Override
    public void close() throws IOException {
        this.cachingProvider.close();
    }
}

