/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.security.core.annotation.AbstractSecurityAnnotationScanner;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.UniqueSecurityAnnotationScanner;
import org.springframework.util.Assert;
import org.springframework.util.PropertyPlaceholderHelper;

final class ExpressionTemplateSecurityAnnotationScanner<A extends Annotation>
extends AbstractSecurityAnnotationScanner<A> {
    private static final DefaultConversionService conversionService = new DefaultConversionService();
    private final Class<A> type;
    private final UniqueSecurityAnnotationScanner<A> unique;
    private final AnnotationTemplateExpressionDefaults templateDefaults;

    ExpressionTemplateSecurityAnnotationScanner(Class<A> type, AnnotationTemplateExpressionDefaults templateDefaults) {
        Assert.notNull(type, (String)"type cannot be null");
        Assert.notNull((Object)templateDefaults, (String)"templateDefaults cannot be null");
        this.type = type;
        this.unique = new UniqueSecurityAnnotationScanner<A>(type);
        this.templateDefaults = templateDefaults;
    }

    @Override
    MergedAnnotation<A> merge(AnnotatedElement element, Class<?> targetClass) {
        if (element instanceof Parameter) {
            Parameter parameter = (Parameter)element;
            MergedAnnotation<A> annotation = this.unique.merge(parameter, targetClass);
            if (annotation == null) {
                return null;
            }
            return this.resolvePlaceholders(annotation);
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            MergedAnnotation<A> annotation = this.unique.merge(method, targetClass);
            if (annotation == null) {
                return null;
            }
            return this.resolvePlaceholders(annotation);
        }
        throw new IllegalArgumentException("Unsupported element of type " + String.valueOf(element.getClass()));
    }

    private MergedAnnotation<A> resolvePlaceholders(MergedAnnotation<A> mergedAnnotation) {
        String asString;
        if (this.templateDefaults == null) {
            return mergedAnnotation;
        }
        if (mergedAnnotation.getMetaSource() == null) {
            return mergedAnnotation;
        }
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("{", "}", null, null, this.templateDefaults.isIgnoreUnknown());
        HashMap<String, String> properties = new HashMap<String, String>(mergedAnnotation.asMap(new MergedAnnotation.Adapt[0]));
        Map metaAnnotationProperties = mergedAnnotation.getMetaSource().asMap(new MergedAnnotation.Adapt[0]);
        HashMap<String, String> stringProperties = new HashMap<String, String>();
        for (Map.Entry entry : metaAnnotationProperties.entrySet()) {
            String string = (String)entry.getKey();
            Object value = entry.getValue();
            asString = value instanceof String ? (String)value : (String)conversionService.convert(value, String.class);
            stringProperties.put(string, asString);
        }
        Map annotationProperties = mergedAnnotation.asMap(new MergedAnnotation.Adapt[0]);
        for (Map.Entry entry : annotationProperties.entrySet()) {
            asString = entry.getValue();
            if (!(asString instanceof String)) continue;
            String expression = asString;
            String value = helper.replacePlaceholders(expression, stringProperties::get);
            properties.put((String)entry.getKey(), value);
        }
        AnnotatedElement annotatedElement = (AnnotatedElement)mergedAnnotation.getSource();
        return MergedAnnotation.of((AnnotatedElement)annotatedElement, this.type, properties);
    }

    static {
        conversionService.addConverter((GenericConverter)new ClassToStringConverter());
    }

    static class ClassToStringConverter
    implements GenericConverter {
        ClassToStringConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Class.class, String.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source != null ? source.toString() : null;
        }
    }
}

