/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.ProcessConnection;
import com.xebialabs.overthere.telnet.TelnetConnection;
import com.xebialabs.overthere.winrm.WinRmConnection;
import com.xebialabs.overthere.winrs.WinrsConnection;

public enum CifsConnectionType {
    TELNET,
    WINRM_INTERNAL,
    WINRM_NATIVE;


    public int getDefaultPort(ConnectionOptions options) {
        switch (this.ordinal()) {
            case 0: {
                return 23;
            }
            case 1: 
            case 2: {
                if (!options.getBoolean("winrmEnableHttps", false)) {
                    return 5985;
                }
                return 5986;
            }
        }
        throw new IllegalArgumentException("Unknown CIFS connection type " + String.valueOf((Object)this));
    }

    public ProcessConnection getProcessConnection(ConnectionOptions options, AddressPortMapper mapper, OverthereFile workingDirectory) {
        return switch (this.ordinal()) {
            case 0 -> new TelnetConnection(options, mapper, workingDirectory);
            case 1 -> new WinRmConnection(options, mapper, workingDirectory);
            case 2 -> new WinrsConnection(options, mapper, workingDirectory);
            default -> throw new IllegalArgumentException("Unknown CIFS connection type " + String.valueOf((Object)this));
        };
    }
}

