/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.spi.exception.SuppressStackTrace;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.List;
import java.util.stream.Collectors;

@HttpResponseCodeResult(statusCode=403)
@SuppressStackTrace(suppressStackTrace=true)
public class PermissionDeniedException
extends DeployitException {
    public PermissionDeniedException(String message, Exception cause) {
        super((Throwable)cause, message, new Object[0]);
    }

    public PermissionDeniedException() {
    }

    public PermissionDeniedException(String message) {
        super(message);
    }

    public static PermissionDeniedException withMessage(String message, Exception cause) {
        return new PermissionDeniedException(message, cause);
    }

    public static PermissionDeniedException withMessage(String message) {
        return new PermissionDeniedException(message);
    }

    public static PermissionDeniedException forNodeAndPrivilege(String id, String privilege) {
        PermissionDeniedException deniedException = new PermissionDeniedException();
        deniedException.add("You do not have %s privilege on %s", new Object[]{privilege, id});
        return deniedException;
    }

    public static PermissionDeniedException forPermission(Permission permission, List<String> onConfigurationItems) {
        PermissionDeniedException deniedException = new PermissionDeniedException();
        deniedException.add("You do not have %s permission on %s", new Object[]{permission, onConfigurationItems});
        return deniedException;
    }

    public static PermissionDeniedException forPermission(Permission permission, String onConfigurationItem) {
        PermissionDeniedException deniedException = new PermissionDeniedException();
        if (onConfigurationItem == null) {
            deniedException.add("You do not have %s permission", new Object[]{permission});
        } else {
            deniedException.add("You do not have %s permission on %s", new Object[]{permission, onConfigurationItem});
        }
        return deniedException;
    }

    public static PermissionDeniedException forPermissions(List<Permission> permissions, String onConfigurationItem) {
        PermissionDeniedException deniedException = new PermissionDeniedException();
        if (onConfigurationItem == null) {
            deniedException.add("You do not have any of the %s permissions", new Object[]{PermissionDeniedException.joinPermissions(permissions)});
        } else {
            deniedException.add("You do not have any of the %s permissions on %s", new Object[]{PermissionDeniedException.joinPermissions(permissions), onConfigurationItem});
        }
        return deniedException;
    }

    private static String joinPermissions(List<Permission> permissions) {
        return permissions.stream().map(Permission::toString).collect(Collectors.joining(", "));
    }
}

