/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.security.authentication.RememberMe;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class BasicAuthWithRememberMeFilter
extends BasicAuthenticationFilter {
    public BasicAuthWithRememberMeFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        super(authenticationManager, authenticationEntryPoint);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        String header = request.getHeader("Authorization");
        String[] tokens = this.extractAndDecodeHeader(header, request);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)tokens[0], (Object)tokens[1], authResult.getAuthorities());
        token.setDetails(authResult.getDetails());
        if (request.getRequestURI().endsWith("logout") && request.getParameterMap().isEmpty()) {
            this.logger.info((Object)("Logging out " + token.getName()));
            RememberMe.forget((Authentication)token);
        } else {
            RememberMe.remember((Authentication)token);
        }
    }

    private String[] extractAndDecodeHeader(String header, HttpServletRequest request) throws IOException {
        byte[] decoded;
        byte[] base64Token = header.substring(6).getBytes(StandardCharsets.UTF_8);
        try {
            decoded = Base64.getDecoder().decode(base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, this.getCredentialsCharset(request));
        int delim = token.indexOf(":");
        if (delim == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }
}

