/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.impl;

import com.xebialabs.deployit.core.rest.ChangeSetResource;
import com.xebialabs.deployit.core.rest.StitchResource;
import com.xebialabs.deployit.core.rest.view.PublishView;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSetService;
import com.xebialabs.deployit.plugin.stitch.service.GitService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.SourceCleanService;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\u0005\n\u0001YA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0006\u0001B\u0001B\u0003%a\u0006C\u00037\u0001\u0011\u0005q\u0007C\u0003>\u0001\u0011\u0005c\bC\u0003Z\u0001\u0011\u0005#\fC\u0003e\u0001\u0011\u0005SMA\u000bDQ\u0006tw-Z*fiJ+7o\\;sG\u0016LU\u000e\u001d7\u000b\u0005)Y\u0011\u0001B5na2T!\u0001D\u0007\u0002\tI,7\u000f\u001e\u0006\u0003\u001d=\tAaY8sK*\u0011\u0001#E\u0001\tI\u0016\u0004Hn\\=ji*\u0011!cE\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001F\u0001\u0004G>l7\u0001A\n\u0004\u0001]Y\u0002C\u0001\r\u001a\u001b\u0005Y\u0011B\u0001\u000e\f\u00059\u0019F/\u001b;dQJ+7o\\;sG\u0016\u0004\"\u0001\u0007\u000f\n\u0005uY!!E\"iC:<WmU3u%\u0016\u001cx.\u001e:dK\u0006\u00012\r[1oO\u0016\u001cV\r^*feZL7-\u001a\t\u0003A\u001dj\u0011!\t\u0006\u0003E\r\nqa]3sm&\u001cWM\u0003\u0002%K\u000511\u000f^5uG\"T!AJ\b\u0002\rAdWoZ5o\u0013\tA\u0013E\u0001\tDQ\u0006tw-Z*fiN+'O^5dK\u0006Qq-\u001b;TKJ4\u0018nY3\u0011\u0005\u0001Z\u0013B\u0001\u0017\"\u0005)9\u0015\u000e^*feZL7-Z\u0001\u0013g>,(oY3DY\u0016\fgnU3sm&\u001cW\r\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005)\u0011N\u001c3fq*\u00111'I\u0001\u0007K:<\u0017N\\3\n\u0005U\u0002$AE*pkJ\u001cWm\u00117fC:\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003\u0002\u001d;wq\u0002\"!\u000f\u0001\u000e\u0003%AQA\b\u0003A\u0002}AQ!\u000b\u0003A\u0002)BQ!\f\u0003A\u00029\nA\u0002\\5ti\n\u0013\u0018M\\2iKN$2aP+X!\r\u0001%*\u0014\b\u0003\u0003\u001es!AQ#\u000e\u0003\rS!\u0001R\u000b\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0015!B:dC2\f\u0017B\u0001%J\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AR\u0005\u0003\u00172\u0013A\u0001T5ti*\u0011\u0001*\u0013\t\u0003\u001dJs!a\u0014)\u0011\u0005\tK\u0015BA)J\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005EK\u0005\"\u0002,\u0006\u0001\u0004i\u0015\u0001C:pkJ\u001cW-\u00133\t\u000ba+\u0001\u0019A'\u0002\u00179\fW.\u001a)biR,'O\\\u0001\baV\u0014G.[:i)\rY\u0016M\u0019\t\u00039~k\u0011!\u0018\u0006\u0003=.\tAA^5fo&\u0011\u0001-\u0018\u0002\f!V\u0014G.[:i-&,w\u000fC\u0003W\r\u0001\u0007Q\nC\u0003d\r\u0001\u0007Q*\u0001\u0006ce\u0006t7\r\u001b(b[\u0016\fq\u0002Z3mKR,7\t[1oO\u0016\u001cV\r\u001e\u000b\u0004M*\\\u0007CA4i\u001b\u0005I\u0015BA5J\u0005\u0011)f.\u001b;\t\u000bY;\u0001\u0019A'\t\u000b\r<\u0001\u0019A')\u0005\u0001i\u0007C\u00018v\u001b\u0005y'B\u00019r\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0003eN\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002i\u0006\u0019qN]4\n\u0005Y|'AC\"p]R\u0014x\u000e\u001c7fe\"\u0012\u0001\u0001\u001f\t\u0004s\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018AC1o]>$\u0018\r^5p]*\u0011QP`\u0001\bM\u0006\u001cGo\u001c:z\u0015\ty\u0018/A\u0003cK\u0006t7/C\u0002\u0002\u0004i\u0014\u0011\"Q;u_^L'/\u001a3")
public class ChangeSetResourceImpl
extends StitchResource
implements ChangeSetResource {
    private final ChangeSetService changeSetService;
    private final GitService gitService;
    private final SourceCleanService sourceCleanService;

    @Override
    public List<String> listBranches(String sourceId, String namePattern) {
        this.checkPermissions();
        return this.changeSetService.listBranches(sourceId, (Option<String>)Option$.MODULE$.apply((Object)namePattern));
    }

    @Override
    public PublishView publish(String sourceId, String branchName) {
        this.checkPermissions(sourceId, PlatformPermissions.EDIT_REPO);
        return this.gitService.publish(this.gitService.fetchGitSourceCi(sourceId), branchName, Permissions.getAuthenticatedUserName());
    }

    @Override
    public void deleteChangeSet(String sourceId, String branchName) {
        this.checkPermissions(sourceId, PlatformPermissions.EDIT_REPO);
        this.gitService.delete(this.gitService.fetchGitSourceCi(sourceId), branchName);
        this.sourceCleanService.cleanSource(this.gitService.fetchGitSourceCi(sourceId), (Option<String>)Option$.MODULE$.apply((Object)branchName));
    }

    public ChangeSetResourceImpl(ChangeSetService changeSetService, GitService gitService, SourceCleanService sourceCleanService) {
        this.changeSetService = changeSetService;
        this.gitService = gitService;
        this.sourceCleanService = sourceCleanService;
    }
}

