/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.shared.common.error.StandardException;

class FromList
extends QueryTreeNodeVector<ResultSetNode>
implements OptimizableList {
    Properties properties;
    boolean fixedJoinOrder = true;
    boolean useStatistics = true;
    private boolean referencesSessionSchema;
    private boolean isTransparent;
    private WindowList windows;

    FromList(ContextManager contextManager) {
        super(ResultSetNode.class, contextManager);
        this.isTransparent = false;
    }

    FromList(boolean bl, ContextManager contextManager) {
        super(ResultSetNode.class, contextManager);
        this.constructorMinion(bl);
    }

    FromList(boolean bl, FromTable fromTable, ContextManager contextManager) throws StandardException {
        super(ResultSetNode.class, contextManager);
        this.constructorMinion(bl);
        this.addFromTable(fromTable);
    }

    private void constructorMinion(boolean bl) {
        this.fixedJoinOrder = !bl;
        this.isTransparent = false;
    }

    @Override
    public Optimizable getOptimizable(int n) {
        return (Optimizable)this.elementAt(n);
    }

    @Override
    public void setOptimizable(int n, Optimizable optimizable) {
        this.setElementAt((FromTable)optimizable, n);
    }

    @Override
    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((Optimizable)this.elementAt(i)).verifyProperties(dataDictionary);
        }
    }

    final void addFromTable(FromTable fromTable) throws StandardException {
        if (!(fromTable instanceof TableOperatorNode)) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                TableName tableName;
                TableName tableName2 = fromTable.getTableName();
                if ((FromTable)this.elementAt(i) instanceof TableOperatorNode || !tableName2.equals(tableName = ((FromTable)this.elementAt(i)).getTableName())) continue;
                throw StandardException.newException((String)"42X09", (Object[])new Object[]{fromTable.getExposedName()});
            }
        }
        this.addElement(fromTable);
    }

    boolean referencesTarget(String string, boolean bl) throws StandardException {
        boolean bl2 = false;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            if (!fromTable.referencesTarget(string, bl)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        boolean bl = false;
        if (this.referencesSessionSchema) {
            return true;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            if (!fromTable.referencesSessionSchema()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        FromTable fromTable = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable2 = (FromTable)this.elementAt(i);
            fromTable = fromTable2.getFromTableByName(string, string2, bl);
            if (fromTable == null) continue;
            return fromTable;
        }
        return fromTable;
    }

    void isJoinColumnForRightOuterJoin(ResultColumn resultColumn) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.isJoinColumnForRightOuterJoin(resultColumn);
        }
    }

    void bindTables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        FromTable fromTable;
        FromTable fromTable2;
        int n;
        boolean bl = this.getCompilerContext().skipTypePrivileges(true);
        int n2 = this.size();
        for (n = 0; n < n2; ++n) {
            fromTable2 = (FromTable)this.elementAt(n);
            fromTable = (FromTable)fromTable2.bindNonVTITables(dataDictionary, fromList);
            if (fromTable2.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            fromTable.setMergeTableID(fromTable2.getMergeTableID());
            this.setElementAt(fromTable, n);
        }
        for (n = 0; n < n2; ++n) {
            fromTable2 = (FromTable)this.elementAt(n);
            fromTable = (FromTable)fromTable2.bindVTITables(fromList);
            if (fromTable2.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            fromTable.setMergeTableID(fromTable2.getMergeTableID());
            this.setElementAt(fromTable, n);
        }
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.pushCurrentPrivType(8);
        for (int i = 0; i < n2; ++i) {
            fromTable2 = (FromTable)this.elementAt(i);
            if (!fromTable2.isPrivilegeCollectionRequired() || !fromTable2.isBaseTable() || fromTable2.forUpdate()) continue;
            compilerContext.addRequiredColumnPriv(fromTable2.getTableDescriptor().getColumnDescriptor(1));
        }
        compilerContext.popCurrentPrivType();
        this.getCompilerContext().skipTypePrivileges(bl);
    }

    void bindExpressions(FromList fromList) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.bindExpressions(this.isTransparent ? fromList : this);
        }
    }

    void bindResultColumns(FromList fromList) throws StandardException {
        int n = fromList.size();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            if (fromTable.needsSpecialRCLBinding()) {
                fromTable.bindResultColumns(fromList);
            }
            fromList.insertElementAt(fromTable, 0);
        }
        while (fromList.size() > n) {
            fromList.removeElementAt(0);
        }
    }

    ResultColumnList expandAll(TableName tableName) throws StandardException {
        FromTable fromTable;
        ResultColumnList resultColumnList = null;
        boolean bl = false;
        int n = ((FromTable)this.elementAt(0)).getLevel();
        int n2 = this.size();
        for (int i = 0; i < n2 && n == (fromTable = (FromTable)this.elementAt(i)).getLevel(); ++i) {
            ResultColumnList resultColumnList2 = fromTable.getAllResultColumns(tableName);
            if (resultColumnList2 == null) continue;
            if (resultColumnList == null) {
                resultColumnList = resultColumnList2;
            } else {
                resultColumnList.nondestructiveAppend(resultColumnList2);
            }
            if (tableName == null) continue;
            bl = true;
        }
        if (resultColumnList == null) {
            throw StandardException.newException((String)"42X10", (Object[])new Object[]{tableName});
        }
        return resultColumnList;
    }

    ResultColumn bindColumnReference(ColumnReference columnReference) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        FromTable fromTable = null;
        FromTable fromTable2 = null;
        int n = -1;
        ResultColumn resultColumn = null;
        String string = columnReference.getTableName();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            fromTable = (FromTable)this.elementAt(i);
            if (fromTable.getMergeTableID() != 0 && columnReference.getMergeTableID() != 0 && fromTable.getMergeTableID() != columnReference.getMergeTableID()) continue;
            int n3 = fromTable.getLevel();
            if (n != n3 && (bl || bl2)) break;
            n = n3;
            ResultColumn resultColumn2 = fromTable.getMatchingColumn(columnReference);
            if (resultColumn2 != null) {
                if (!bl) {
                    resultColumn = resultColumn2;
                    columnReference.setSource(resultColumn2);
                    columnReference.setNestingLevel(((FromTable)this.elementAt(0)).getLevel());
                    columnReference.setSourceLevel(n3);
                    bl = true;
                    if (fromTable.isPrivilegeCollectionRequired()) {
                        this.getCompilerContext().addRequiredColumnPriv(resultColumn2.getTableColumnDescriptor());
                    }
                    fromTable2 = fromTable;
                } else {
                    throw StandardException.newException((String)"42X03", (Object[])new Object[]{columnReference.getSQLColumnName()});
                }
            }
            bl2 = bl2 || string != null && string.equals(fromTable.getExposedName());
        }
        if (fromTable2 != null && resultColumn != null && columnReference.getTableName() == null) {
            FromBaseTable fromBaseTable;
            TableName tableName = fromTable2.getTableName();
            if (fromTable2 instanceof FromBaseTable && (fromBaseTable = (FromBaseTable)fromTable2).getExposedTableName() != null) {
                tableName = fromBaseTable.getExposedTableName();
            }
            columnReference.setQualifiedTableName(tableName);
        }
        return resultColumn;
    }

    void rejectParameters() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.rejectParameters();
        }
    }

    boolean LOJ_reorderable(int n) throws StandardException {
        boolean bl = false;
        if (this.size() > 1) {
            return bl;
        }
        FromTable fromTable = (FromTable)this.elementAt(0);
        bl = fromTable.LOJ_reorderable(n);
        return bl;
    }

    void preprocess(int n, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable = fromTable.transformOuterJoins(valueNode, n);
            this.setElementAt(fromTable.preprocess(n, groupByList, this), i);
        }
    }

    void flattenFromTables(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        QueryTreeNode queryTreeNode;
        FromTable fromTable;
        int n;
        boolean bl = true;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (bl) {
            bl = false;
            for (n = 0; n < this.size() && !bl; ++n) {
                fromTable = (FromTable)this.elementAt(n);
                if (!(fromTable instanceof FromSubquery) && !fromTable.isFlattenableJoinNode()) continue;
                arrayList.add(fromTable.getTableNumber());
                queryTreeNode = fromTable.flatten(resultColumnList, predicateList, subqueryList, groupByList, valueNode);
                if (queryTreeNode != null) {
                    this.setElementAt((ResultSetNode)((QueryTreeNodeVector)queryTreeNode).elementAt(0), n);
                    int n2 = ((QueryTreeNodeVector)queryTreeNode).size();
                    for (int i = 1; i < n2; ++i) {
                        this.insertElementAt((ResultSetNode)((QueryTreeNodeVector)queryTreeNode).elementAt(i), n + i);
                    }
                } else {
                    this.removeElementAt(n);
                }
                bl = true;
            }
        }
        if (!arrayList.isEmpty()) {
            for (n = 0; n < this.size(); ++n) {
                fromTable = (FromTable)this.elementAt(n);
                if (!(fromTable instanceof ProjectRestrictNode) || !((queryTreeNode = ((ProjectRestrictNode)fromTable).getChildResult()) instanceof FromBaseTable)) continue;
                ((FromBaseTable)queryTreeNode).clearDependency(arrayList);
            }
        }
    }

    void pushPredicates(PredicateList predicateList) throws StandardException {
        predicateList.categorize();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.pushExpressions(predicateList);
        }
    }

    void setLevel(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.setLevel(n);
        }
    }

    FromTable getFromTableByResultColumn(ResultColumn resultColumn) {
        FromTable fromTable = null;
        int n = this.size();
        for (int i = 0; i < n && (fromTable = (FromTable)this.elementAt(i)).getResultColumns().indexOf(resultColumn) == -1; ++i) {
        }
        return fromTable;
    }

    void setProperties(Properties properties) throws StandardException {
        this.properties = properties;
        Enumeration<Object> enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.properties.get(string);
            if (string.equals("joinOrder")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "fixed")) {
                    this.fixedJoinOrder = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "unfixed")) {
                    this.fixedJoinOrder = false;
                    continue;
                }
                throw StandardException.newException((String)"42X17", (Object[])new Object[]{string2});
            }
            if (string.equals("useStatistics")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "true")) {
                    this.useStatistics = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "false")) {
                    this.useStatistics = false;
                    continue;
                }
                throw StandardException.newException((String)"42X64", (Object[])new Object[]{string2});
            }
            throw StandardException.newException((String)"42X41", (Object[])new Object[]{string, string2});
        }
    }

    @Override
    public void reOrder(int[] nArray) {
        int n;
        FromTable[] fromTableArray = new FromTable[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            fromTableArray[n] = (ResultSetNode)this.elementAt(nArray[n]);
        }
        for (n = 0; n < nArray.length; ++n) {
            this.setElementAt(fromTableArray[n], n);
        }
    }

    @Override
    public boolean useStatistics() {
        return this.useStatistics;
    }

    @Override
    public boolean optimizeJoinOrder() {
        return !this.fixedJoinOrder;
    }

    @Override
    public boolean legalJoinOrder(int n) {
        JBitSet jBitSet = new JBitSet(n);
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            jBitSet.or(fromTable.getReferencedTableMap());
            if (fromTable.legalJoinOrder(jBitSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.initAccessPaths(optimizer);
        }
    }

    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.bindUntypedNullsToResultColumns(resultColumnList);
        }
    }

    void decrementLevel(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.decrementLevel(n);
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)fromTable;
            PredicateList predicateList = projectRestrictNode.getRestrictionList();
            if (predicateList == null) continue;
            predicateList.decrementLevel(this, n);
        }
    }

    boolean returnsAtMostSingleRow(ResultColumnList resultColumnList, ValueNode valueNode, PredicateList predicateList, DataDictionary dataDictionary) throws StandardException {
        int n;
        Object object;
        Object object2;
        boolean bl = false;
        ColumnReference columnReference = null;
        PredicateList predicateList2 = new PredicateList(this.getContextManager());
        Object object3 = predicateList.iterator();
        while (object3.hasNext()) {
            Predicate predicate = (Predicate)object3.next();
            predicateList2.addPredicate(predicate);
        }
        if (resultColumnList != null && ((ResultColumn)(object3 = (ResultColumn)resultColumnList.elementAt(0))).getExpression() instanceof ColumnReference) {
            columnReference = (ColumnReference)((ResultColumn)object3).getExpression();
        }
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            object2 = (FromTable)this.elementAt(i);
            if (!(object2 instanceof ProjectRestrictNode)) {
                return false;
            }
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)object2;
            if (!(projectRestrictNode.getChildResult() instanceof FromBaseTable)) {
                return false;
            }
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            if (!fromBaseTable.getExistsBaseTable()) continue;
            int n3 = fromBaseTable.getTableNumber();
            block2: for (int j = predicateList2.size() - 1; j >= 0; --j) {
                AndNode andNode = ((Predicate)predicateList2.elementAt(j)).getAndNode();
                object = andNode;
                while (object instanceof AndNode) {
                    JBitSet jBitSet;
                    AndNode andNode2 = (AndNode)object;
                    if (andNode2.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)andNode2.getLeftOperand())).getOperator() == 1 && (jBitSet = andNode2.getLeftOperand().getTablesReferenced()).get(n3)) {
                        predicateList2.removeElementAt(j);
                        continue block2;
                    }
                    object = ((AndNode)object).getRightOperand();
                }
            }
        }
        int[] nArray = this.getTableNumbers();
        JBitSet[][] jBitSetArray = new JBitSet[n2][n2];
        object2 = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(n);
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            if (fromBaseTable.getExistsBaseTable()) {
                object2[n] = true;
                continue;
            }
            int n4 = fromBaseTable.getTableDescriptor().getNumberOfColumns();
            object = new boolean[n4 + 1];
            int n5 = fromBaseTable.getTableNumber();
            boolean bl2 = false;
            for (int i = 0; i < n2; ++i) {
                jBitSetArray[n][i] = new JBitSet(n4 + 1);
            }
            if (columnReference != null && columnReference.getTableNumber() == n5) {
                resultColumnList.recordColumnReferences((boolean[])object, jBitSetArray[n], n);
                bl2 = true;
            }
            if (valueNode != null) {
                valueNode.checkTopPredicatesForEqualsConditions(n5, (boolean[])object, nArray, jBitSetArray[n], bl2);
            }
            predicateList2.checkTopPredicatesForEqualsConditions(n5, (boolean[])object, nArray, jBitSetArray[n], bl2);
            if (projectRestrictNode.getRestrictionList() != null) {
                projectRestrictNode.getRestrictionList().checkTopPredicatesForEqualsConditions(n5, (boolean[])object, nArray, jBitSetArray[n], bl2);
            }
            if (!fromBaseTable.supersetOfUniqueIndex(jBitSetArray[n])) {
                return false;
            }
            boolean bl3 = fromBaseTable.supersetOfUniqueIndex((boolean[])object);
            if (!bl3) continue;
            object2[n] = true;
            bl = true;
        }
        if (bl) {
            n = 1;
            while (n != 0) {
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    if (object2[i] == false) continue;
                    for (int j = 0; j < n2; ++j) {
                        if (object2[j] != false || !jBitSetArray[j][i].get(0)) continue;
                        object2[j] = true;
                        n = 1;
                    }
                }
            }
            for (int i = 0; i < n2; ++i) {
                if (object2[i] != false) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    int[] getTableNumbers() {
        int n = this.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(i);
            if (!(projectRestrictNode.getChildResult() instanceof FromTable)) continue;
            FromTable fromTable = (FromTable)projectRestrictNode.getChildResult();
            nArray[i] = fromTable.getTableNumber();
        }
        return nArray;
    }

    void genExistsBaseTables(JBitSet jBitSet, FromList fromList, boolean bl) throws StandardException {
        int n;
        JBitSet jBitSet2 = (JBitSet)jBitSet.clone();
        int n2 = this.size();
        for (n = 0; n < n2; ++n) {
            ResultSetNode resultSetNode = ((ProjectRestrictNode)this.elementAt(n)).getChildResult();
            if (!(resultSetNode instanceof FromTable)) continue;
            jBitSet2.clear(((FromTable)resultSetNode).getTableNumber());
        }
        if (jBitSet2.getFirstSetBit() == -1) {
            n = fromList.size();
            for (int i = 0; i < n; ++i) {
                jBitSet2.or(((FromTable)fromList.elementAt(i)).getReferencedTableMap());
            }
        }
        for (n = 0; n < n2; ++n) {
            ProjectRestrictNode projectRestrictNode;
            FromTable fromTable = (FromTable)this.elementAt(n);
            if (!(fromTable instanceof ProjectRestrictNode) || !((projectRestrictNode = (ProjectRestrictNode)fromTable).getChildResult() instanceof FromBaseTable)) continue;
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            fromBaseTable.setExistsBaseTable(true, (JBitSet)jBitSet2.clone(), bl);
        }
    }

    boolean tableNumberIsNotExists(int n) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable;
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(i);
            if (!(projectRestrictNode.getChildResult() instanceof FromTable) || (fromTable = (FromTable)projectRestrictNode.getChildResult()).getTableNumber() != n) continue;
            return fromTable.isNotExists();
        }
        return false;
    }

    int updateTargetLockMode() {
        return ((ResultSetNode)this.elementAt(0)).updateTargetLockMode();
    }

    boolean hashJoinSpecified() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            String string = fromTable.getUserSpecifiedJoinStrategy();
            if (string == null || !StringUtil.SQLToUpperCase(string).equals("HASH")) continue;
            return true;
        }
        return false;
    }

    void markAsTransparent() {
        this.isTransparent = true;
    }

    void setWindows(WindowList windowList) {
        this.windows = windowList;
    }

    WindowList getWindows() {
        return this.windows;
    }
}

