/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import jakarta.transaction.Transaction;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.TransactionImpl;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.SingleKeyNonTxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

@Scope(value=Scopes.NAMED_CACHE)
public class XSiteStateConsumerImpl
implements XSiteStateConsumer {
    private static final long STATE_TRANSFER_PUT_FLAGS = EnumUtil.bitSetOf((Enum)Flag.PUT_FOR_X_SITE_STATE_TRANSFER, (Enum)Flag.IGNORE_RETURN_VALUES, (Enum[])new Enum[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_XSITE_BACKUP, Flag.IRAC_STATE});
    private static final Log log = LogFactory.getLog(XSiteStateConsumerImpl.class);
    private static final AtomicLong TX_ID_GENERATOR = new AtomicLong(0L);
    @Inject
    TransactionTable transactionTable;
    @Inject
    InvocationContextFactory invocationContextFactory;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    AsyncInterceptorChain interceptorChain;
    @Inject
    CommitManager commitManager;
    @Inject
    KeyPartitioner keyPartitioner;
    private final boolean isTxVersioned;
    private final boolean isTransactional;
    private final AtomicReference<String> sendingSite = new AtomicReference<Object>(null);

    public XSiteStateConsumerImpl(Configuration configuration) {
        this.isTxVersioned = Configurations.isTxVersioned(configuration);
        this.isTransactional = configuration.transaction().transactionMode().isTransactional();
    }

    @Override
    public void startStateTransfer(String sendingSite) {
        log.debugf("Starting state transfer. Receiving from %s", sendingSite);
        if (!this.sendingSite.compareAndSet(null, sendingSite)) {
            throw new CacheException("Already receiving state from " + this.sendingSite.get());
        }
        this.commitManager.startTrack(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
    }

    @Override
    public void endStateTransfer(String sendingSite) {
        if (log.isDebugEnabled()) {
            log.debugf("Ending state transfer from %s", sendingSite);
        }
        String currentSendingSite = this.sendingSite.get();
        if (sendingSite == null || sendingSite.equals(currentSendingSite)) {
            this.sendingSite.set(null);
            this.commitManager.stopTrack(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
        } else if (log.isDebugEnabled()) {
            log.debugf("Received an end request from a non-sender site. Expects %s but got %s", currentSendingSite, sendingSite);
        }
    }

    @Override
    public void applyState(XSiteState[] chunk) throws Exception {
        if (log.isDebugEnabled()) {
            log.debugf("Received state: %s keys", chunk.length);
        }
        if (this.isTransactional) {
            this.applyStateInTransaction(chunk);
        } else {
            this.applyStateInNonTransaction(chunk);
        }
    }

    @Override
    public String getSendingSiteName() {
        return this.sendingSite.get();
    }

    private void applyStateInTransaction(XSiteState[] chunk) {
        XSiteApplyStateTransaction tx = new XSiteApplyStateTransaction();
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext((Transaction)tx, false);
        assert (ctx instanceof LocalTxInvocationContext);
        LocalTransaction localTransaction = (LocalTransaction)((LocalTxInvocationContext)ctx).getCacheTransaction();
        try {
            localTransaction.setStateTransferFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
            for (XSiteState siteState : chunk) {
                this.interceptorChain.invoke(ctx, this.createPut(siteState));
                if (!log.isTraceEnabled()) continue;
                log.tracef("Successfully applied key'%s'", siteState);
            }
            this.invoke1PCPrepare(localTransaction);
            if (log.isDebugEnabled()) {
                log.debugf("Successfully applied state. %s keys inserted", chunk.length);
            }
        }
        catch (Exception e) {
            log.unableToApplyXSiteState(e);
            this.safeRollback(localTransaction);
            throw e;
        }
        finally {
            this.transactionTable.removeLocalTransaction(localTransaction);
        }
    }

    private void applyStateInNonTransaction(XSiteState[] chunk) {
        SingleKeyNonTxInvocationContext ctx = (SingleKeyNonTxInvocationContext)this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
        for (XSiteState siteState : chunk) {
            PutKeyValueCommand command = this.createPut(siteState);
            ctx.setLockOwner(command.getKeyLockOwner());
            this.interceptorChain.invoke(ctx, command);
            ctx.resetState();
            if (!log.isTraceEnabled()) continue;
            log.tracef("Successfully applied key'%s'", siteState);
        }
        if (log.isDebugEnabled()) {
            log.debugf("Successfully applied state. %s keys inserted", chunk.length);
        }
    }

    private PutKeyValueCommand createPut(XSiteState state) {
        Object key = state.key();
        PutKeyValueCommand cmd = this.commandsFactory.buildPutKeyValueCommand(key, state.value(), this.keyPartitioner.getSegment(key), state.metadata(), STATE_TRANSFER_PUT_FLAGS);
        cmd.setInternalMetadata(state.internalMetadata());
        return cmd;
    }

    private void invoke1PCPrepare(LocalTransaction localTransaction) {
        PrepareCommand prepareCommand = this.isTxVersioned ? this.commandsFactory.buildVersionedPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), true) : this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), true);
        LocalTxInvocationContext ctx = this.invocationContextFactory.createTxInvocationContext(localTransaction);
        this.interceptorChain.invoke(ctx, prepareCommand);
    }

    private void safeRollback(LocalTransaction localTransaction) {
        block2: {
            try {
                RollbackCommand prepareCommand = this.commandsFactory.buildRollbackCommand(localTransaction.getGlobalTransaction());
                LocalTxInvocationContext ctx = this.invocationContextFactory.createTxInvocationContext(localTransaction);
                this.interceptorChain.invokeAsync(ctx, prepareCommand);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error rollbacking transaction.", e);
            }
        }
    }

    private static class XSiteApplyStateTransaction
    extends TransactionImpl {
        static final int FORMAT_ID = 3;

        XSiteApplyStateTransaction() {
            byte[] bytes = new byte[8];
            Util.longToBytes((long)TX_ID_GENERATOR.incrementAndGet(), (byte[])bytes, (int)0);
            XidImpl xid = XidImpl.create((int)3, (byte[])bytes, (byte[])bytes);
            this.setXid(xid);
        }
    }
}

