/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.File;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.KnownHostsFileIsValid;

public class KnownHostsFileValidator
implements ConstraintValidator<KnownHostsFileIsValid, MultipleJGitEnvironmentProperties> {
    public void initialize(KnownHostsFileIsValid knownHostsFileIsValid) {
    }

    public boolean isValid(MultipleJGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        String knownHostsFile = sshUriProperties.getKnownHostsFile();
        if (knownHostsFile != null && !new File(knownHostsFile).exists()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("File '%s' specified in property 'spring.cloud.config.server.git.knownHostsFile' could not be located", knownHostsFile)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

