/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.SimpleDirContextAuthenticationStrategy;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.util.Assert;

public class DefaultSpringSecurityContextSource
extends LdapContextSource {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public DefaultSpringSecurityContextSource(String providerUrl) {
        Assert.hasLength((String)providerUrl, (String)"An LDAP connection URL must be supplied.");
        StringTokenizer tokenizer = new StringTokenizer(providerUrl);
        ArrayList<String> urls = new ArrayList<String>();
        String rootDn = null;
        while (tokenizer.hasMoreTokens()) {
            String url = tokenizer.nextToken();
            String urlRootDn = LdapUtils.parseRootDnFromUrl(url);
            urls.add(url.substring(0, url.lastIndexOf(urlRootDn)));
            this.logger.info((Object)LogMessage.format((String)"Configure with URL %s and root DN %s", (Object)url, (Object)urlRootDn));
            Assert.isTrue((rootDn == null || rootDn.equals(urlRootDn) ? 1 : 0) != 0, (String)"Root DNs must be the same when using multiple URLs");
            rootDn = rootDn != null ? rootDn : urlRootDn;
        }
        this.setUrls(urls.toArray(new String[0]));
        this.setBase(rootDn != null ? this.decodeUrl(rootDn) : null);
        this.setPooled(true);
        this.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy(){

            public void setupEnvironment(Hashtable env, String dn, String password) {
                super.setupEnvironment(env, dn, password);
                if (!DefaultSpringSecurityContextSource.this.getUserDn().equals(dn) && env.containsKey("com.sun.jndi.ldap.connect.pool")) {
                    DefaultSpringSecurityContextSource.this.logger.trace((Object)("Removing pooling flag for user " + dn));
                    env.remove("com.sun.jndi.ldap.connect.pool");
                }
            }
        });
    }

    public DefaultSpringSecurityContextSource(List<String> urls, String baseDn) {
        this(DefaultSpringSecurityContextSource.buildProviderUrl(urls, baseDn));
    }

    private static String buildProviderUrl(List<String> urls, String baseDn) {
        Assert.notNull((Object)baseDn, (String)"The Base DN for the LDAP server must not be null.");
        Assert.notEmpty(urls, (String)"At least one LDAP server URL must be provided.");
        String encodedBaseDn = DefaultSpringSecurityContextSource.encodeUrl(baseDn.trim());
        StringBuilder providerUrl = new StringBuilder();
        for (String serverUrl : urls) {
            String trimmedUrl = serverUrl.trim();
            if (trimmedUrl.isEmpty()) continue;
            providerUrl.append(trimmedUrl);
            if (!trimmedUrl.endsWith("/")) {
                providerUrl.append("/");
            }
            providerUrl.append(encodedBaseDn);
            providerUrl.append(" ");
        }
        return providerUrl.toString();
    }

    private static String encodeUrl(String url) {
        return URLEncoder.encode(url, StandardCharsets.UTF_8);
    }

    private String decodeUrl(String url) {
        return URLDecoder.decode(url, StandardCharsets.UTF_8);
    }
}

