/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.saml2;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.saml2.RegistrationConfiguredCondition;
import org.springframework.boot.autoconfigure.security.saml2.Saml2RelyingPartyProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadata;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Conditional(value={RegistrationConfiguredCondition.class})
@ConditionalOnMissingBean(value={RelyingPartyRegistrationRepository.class})
class Saml2RelyingPartyRegistrationConfiguration {
    Saml2RelyingPartyRegistrationConfiguration() {
    }

    @Bean
    RelyingPartyRegistrationRepository relyingPartyRegistrationRepository(Saml2RelyingPartyProperties properties) {
        List<RelyingPartyRegistration> registrations = properties.getRegistration().entrySet().stream().map(this::asRegistration).toList();
        return new InMemoryRelyingPartyRegistrationRepository(registrations);
    }

    private RelyingPartyRegistration asRegistration(Map.Entry<String, Saml2RelyingPartyProperties.Registration> entry) {
        return this.asRegistration(entry.getKey(), entry.getValue());
    }

    private RelyingPartyRegistration asRegistration(String id, Saml2RelyingPartyProperties.Registration properties) {
        boolean usingMetadata = StringUtils.hasText((String)properties.getAssertingparty().getMetadataUri());
        RelyingPartyRegistration.Builder builder = !usingMetadata ? RelyingPartyRegistration.withRegistrationId((String)id) : this.createBuilderUsingMetadata(properties.getAssertingparty()).registrationId(id);
        builder.assertionConsumerServiceLocation(properties.getAcs().getLocation());
        builder.assertionConsumerServiceBinding(properties.getAcs().getBinding());
        builder.assertingPartyMetadata(this.mapAssertingParty(properties.getAssertingparty()));
        builder.signingX509Credentials(credentials -> properties.getSigning().getCredentials().stream().map(this::asSigningCredential).forEach(credentials::add));
        builder.decryptionX509Credentials(credentials -> properties.getDecryption().getCredentials().stream().map(this::asDecryptionCredential).forEach(credentials::add));
        builder.assertingPartyMetadata(details -> details.verificationX509Credentials(credentials -> properties.getAssertingparty().getVerification().getCredentials().stream().map(this::asVerificationCredential).forEach(credentials::add)));
        builder.singleLogoutServiceLocation(properties.getSinglelogout().getUrl());
        builder.singleLogoutServiceResponseLocation(properties.getSinglelogout().getResponseUrl());
        builder.singleLogoutServiceBinding(properties.getSinglelogout().getBinding());
        builder.entityId(properties.getEntityId());
        builder.nameIdFormat(properties.getNameIdFormat());
        RelyingPartyRegistration registration = builder.build();
        boolean signRequest = registration.getAssertingPartyMetadata().getWantAuthnRequestsSigned();
        this.validateSigningCredentials(properties, signRequest);
        return registration;
    }

    private RelyingPartyRegistration.Builder createBuilderUsingMetadata(Saml2RelyingPartyProperties.AssertingParty properties) {
        String requiredEntityId = properties.getEntityId();
        Collection candidates = RelyingPartyRegistrations.collectionFromMetadataLocation((String)properties.getMetadataUri());
        for (RelyingPartyRegistration.Builder candidate : candidates) {
            if (requiredEntityId != null && !requiredEntityId.equals(this.getEntityId(candidate))) continue;
            return candidate;
        }
        throw new IllegalStateException("No relying party with Entity ID '" + requiredEntityId + "' found");
    }

    private Object getEntityId(RelyingPartyRegistration.Builder candidate) {
        String[] result = new String[1];
        candidate.assertingPartyMetadata(builder -> {
            result[0] = builder.build().getEntityId();
        });
        return result[0];
    }

    private Consumer<AssertingPartyMetadata.Builder<?>> mapAssertingParty(Saml2RelyingPartyProperties.AssertingParty assertingParty) {
        return details -> {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(assertingParty::getEntityId).to(arg_0 -> ((AssertingPartyMetadata.Builder)details).entityId(arg_0));
            map.from(assertingParty.getSinglesignon()::getBinding).to(arg_0 -> ((AssertingPartyMetadata.Builder)details).singleSignOnServiceBinding(arg_0));
            map.from(assertingParty.getSinglesignon()::getUrl).to(arg_0 -> ((AssertingPartyMetadata.Builder)details).singleSignOnServiceLocation(arg_0));
            map.from(assertingParty.getSinglesignon()::getSignRequest).to(arg_0 -> ((AssertingPartyMetadata.Builder)details).wantAuthnRequestsSigned(arg_0));
            map.from(assertingParty.getSinglelogout()::getUrl).to(arg_0 -> ((AssertingPartyMetadata.Builder)details).singleLogoutServiceLocation(arg_0));
            map.from(assertingParty.getSinglelogout()::getResponseUrl).to(arg_0 -> ((AssertingPartyMetadata.Builder)details).singleLogoutServiceResponseLocation(arg_0));
            map.from(assertingParty.getSinglelogout()::getBinding).to(arg_0 -> ((AssertingPartyMetadata.Builder)details).singleLogoutServiceBinding(arg_0));
        };
    }

    private void validateSigningCredentials(Saml2RelyingPartyProperties.Registration properties, boolean signRequest) {
        if (signRequest) {
            Assert.state((!properties.getSigning().getCredentials().isEmpty() ? 1 : 0) != 0, (String)"Signing credentials must not be empty when authentication requests require signing.");
        }
    }

    private Saml2X509Credential asSigningCredential(Saml2RelyingPartyProperties.Registration.Signing.Credential properties) {
        RSAPrivateKey privateKey = this.readPrivateKey(properties.getPrivateKeyLocation());
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential((PrivateKey)privateKey, certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.SIGNING});
    }

    private Saml2X509Credential asDecryptionCredential(Saml2RelyingPartyProperties.Decryption.Credential properties) {
        RSAPrivateKey privateKey = this.readPrivateKey(properties.getPrivateKeyLocation());
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential((PrivateKey)privateKey, certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.DECRYPTION});
    }

    private Saml2X509Credential asVerificationCredential(Saml2RelyingPartyProperties.AssertingParty.Verification.Credential properties) {
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential(certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.ENCRYPTION, Saml2X509Credential.Saml2X509CredentialType.VERIFICATION});
    }

    private RSAPrivateKey readPrivateKey(Resource location) {
        RSAPrivateKey rSAPrivateKey;
        block8: {
            Assert.state((location != null ? 1 : 0) != 0, (String)"No private key location specified");
            Assert.state((boolean)location.exists(), () -> "Private key location '" + String.valueOf(location) + "' does not exist");
            InputStream inputStream = location.getInputStream();
            try {
                PemContent pemContent = PemContent.load((InputStream)inputStream);
                PrivateKey privateKey = pemContent.getPrivateKey();
                Assert.isInstanceOf(RSAPrivateKey.class, (Object)privateKey, (String)("PrivateKey in resource '" + String.valueOf(location) + "' must be an RSAPrivateKey"));
                rSAPrivateKey = (RSAPrivateKey)privateKey;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            inputStream.close();
        }
        return rSAPrivateKey;
    }

    private X509Certificate readCertificate(Resource location) {
        X509Certificate x509Certificate;
        block8: {
            Assert.state((location != null ? 1 : 0) != 0, (String)"No certificate location specified");
            Assert.state((boolean)location.exists(), () -> "Certificate  location '" + String.valueOf(location) + "' does not exist");
            InputStream inputStream = location.getInputStream();
            try {
                PemContent pemContent = PemContent.load((InputStream)inputStream);
                List certificates = pemContent.getCertificates();
                x509Certificate = (X509Certificate)certificates.get(0);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            inputStream.close();
        }
        return x509Certificate;
    }
}

