/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.tsp.ers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.python.bouncycastle.operator.DigestCalculator;
import org.python.bouncycastle.tsp.ers.ERSCachingData;
import org.python.bouncycastle.tsp.ers.ERSUtil;

public class ERSInputStreamData
extends ERSCachingData {
    private final InputStream content;

    public ERSInputStreamData(File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("directory not allowed");
        }
        this.content = new FileInputStream(file);
    }

    public ERSInputStreamData(InputStream inputStream) {
        this.content = inputStream;
    }

    @Override
    protected byte[] calculateHash(DigestCalculator digestCalculator, byte[] byArray) {
        byte[] byArray2 = ERSUtil.calculateDigest(digestCalculator, this.content);
        if (byArray != null) {
            return ERSUtil.concatPreviousHashes(digestCalculator, byArray, byArray2);
        }
        return byArray2;
    }
}

