/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.users.internal;

import com.vladsch.flexmark.ext.gfm.users.GfmUser;
import com.vladsch.flexmark.ext.gfm.users.internal.GfmUsersOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GfmUsersJiraRenderer
implements NodeRenderer {
    private final GfmUsersOptions options;

    public GfmUsersJiraRenderer(DataHolder options) {
        this.options = new GfmUsersOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Collections.singletonList(new NodeRenderingHandler(GfmUser.class, this::render)));
    }

    private void render(GfmUser node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            html.raw((CharSequence)node.getChars());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.options.gitHubIssuesUrlRoot).append(this.options.gitHubIssueUrlPrefix).append((CharSequence)node.getText()).append(this.options.gitHubIssueUrlSuffix);
            html.raw((CharSequence)"[");
            html.raw((CharSequence)node.getChars());
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"|")).raw((CharSequence)sb.toString())).raw((CharSequence)"]");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new GfmUsersJiraRenderer(options);
        }
    }
}

