/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class CiReference {
    private final ConfigurationItem ci;
    private final PropertyDescriptor property;
    private final List<String> ids = new ArrayList<String>();

    public CiReference(ConfigurationItem ci, PropertyDescriptor property, List<String> ids) {
        this.ci = ci;
        this.property = property;
        this.ids.addAll(ids);
    }

    public CiReference(ConfigurationItem owner, PropertyDescriptor property, String reference) {
        this.ci = owner;
        this.property = property;
        this.ids.add(reference);
    }

    public ConfigurationItem getCi() {
        return this.ci;
    }

    public PropertyDescriptor getProperty() {
        return this.property;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void set(List<ConfigurationItem> cis) {
        switch (this.property.getKind()) {
            case LIST_OF_CI: {
                this.property.set(this.ci, new ArrayList<ConfigurationItem>(cis));
                break;
            }
            case SET_OF_CI: {
                this.property.set(this.ci, new HashSet<ConfigurationItem>(cis));
                break;
            }
            case CI: {
                if (cis.size() > 0) {
                    this.property.set(this.ci, (Object)cis.get(0));
                    break;
                }
                this.property.set(this.ci, null);
                break;
            }
            default: {
                throw new IllegalStateException("Can't set CI reference of kind " + String.valueOf(this.property.getKind()));
            }
        }
    }

    public String toString() {
        return String.format("%s=>%s = %s", this.ci.getId(), this.property.getName(), this.ids);
    }
}

