/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations;

import org.hibernate.AssertionFailure;
import org.hibernate.cache.spi.access.AccessType;

public enum CacheConcurrencyStrategy {
    NONE,
    READ_ONLY,
    NONSTRICT_READ_WRITE,
    READ_WRITE,
    TRANSACTIONAL;


    public AccessType toAccessType() {
        switch (this) {
            case NONE: {
                return null;
            }
            case READ_ONLY: {
                return AccessType.READ_ONLY;
            }
            case NONSTRICT_READ_WRITE: {
                return AccessType.NONSTRICT_READ_WRITE;
            }
            case READ_WRITE: {
                return AccessType.READ_WRITE;
            }
            case TRANSACTIONAL: {
                return AccessType.TRANSACTIONAL;
            }
        }
        throw new AssertionFailure("unknown CacheConcurrencyStrategy");
    }

    public static CacheConcurrencyStrategy fromAccessType(AccessType accessType) {
        if (accessType == null) {
            return NONE;
        }
        switch (accessType) {
            case READ_ONLY: {
                return READ_ONLY;
            }
            case READ_WRITE: {
                return READ_WRITE;
            }
            case NONSTRICT_READ_WRITE: {
                return NONSTRICT_READ_WRITE;
            }
            case TRANSACTIONAL: {
                return TRANSACTIONAL;
            }
        }
        return NONE;
    }

    public static CacheConcurrencyStrategy parse(String name) {
        for (CacheConcurrencyStrategy strategy : CacheConcurrencyStrategy.values()) {
            if (!strategy.isMatch(name)) continue;
            return strategy;
        }
        return null;
    }

    private boolean isMatch(String name) {
        AccessType accessType = this.toAccessType();
        return accessType != null && accessType.getExternalName().equalsIgnoreCase(name) || this.name().equalsIgnoreCase(name);
    }
}

