/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BorderProperty
extends JETAProperty {
    static final long serialVersionUID = -9007148666135189228L;
    public static final int VERSION = 4;
    private boolean m_top = true;
    private boolean m_left = true;
    private boolean m_right = true;
    private boolean m_bottom = true;
    private boolean m_include_title;
    private String m_title;
    private int m_justification = 0;
    private int m_position = 0;
    private static ColorProperty DEFAULT_TEXT_COLOR;
    private ColorProperty m_text_color = new ColorProperty("TitledBorder.titleColor");
    public static final String PROPERTY_ID = "border";
    static final /* synthetic */ boolean $assertionsDisabled;

    public BorderProperty() {
        super(PROPERTY_ID);
    }

    public Border createBorder(Component component) {
        return null;
    }

    public Border createTitle(Border border) {
        if (this.isIncludeTitle()) {
            return BorderFactory.createTitledBorder(border, this.getTitle(), this.getJustification(), this.getPosition(), this.getTextFont(), this.getTextColor());
        }
        return border;
    }

    public boolean equals(Object object) {
        if (object instanceof BorderProperty) {
            BorderProperty borderProperty = (BorderProperty)object;
            return super.equals(object) && this.m_top == borderProperty.m_top && this.m_left == borderProperty.m_left && this.m_right == borderProperty.m_right && this.m_bottom == borderProperty.m_bottom && this.m_include_title == borderProperty.m_include_title && BorderProperty.isEqual(this.m_title, borderProperty.m_title) && this.m_justification == borderProperty.m_justification && this.m_position == borderProperty.m_position && BorderProperty.isEqual(this.m_text_color, borderProperty.m_text_color);
        }
        return false;
    }

    public static int fromPositionString(String string) {
        if ("ABOVE_TOP".equals(string)) {
            return 1;
        }
        if ("TOP".equals(string)) {
            return 2;
        }
        if ("BELOW_TOP".equals(string)) {
            return 3;
        }
        if ("ABOVE_BOTTOM".equals(string)) {
            return 4;
        }
        if ("BOTTOM".equals(string)) {
            return 5;
        }
        if ("BELOW_BOTTOM".equals(string)) {
            return 6;
        }
        return 0;
    }

    public static int fromJustificationString(String string) {
        if ("LEFT".equals(string)) {
            return 1;
        }
        if ("CENTER".equals(string)) {
            return 2;
        }
        if ("RIGHT".equals(string)) {
            return 3;
        }
        if ("LEADING".equals(string)) {
            return 4;
        }
        if ("TRAILING".equals(string)) {
            return 5;
        }
        return 0;
    }

    public boolean isIncludeTitle() {
        return this.m_include_title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getJustification() {
        return this.m_justification;
    }

    public int getPosition() {
        return this.m_position;
    }

    public Color getTextColor() {
        return this.m_text_color.getColor();
    }

    public ColorProperty getTextColorProperty() {
        return this.m_text_color;
    }

    public Font getTextFont() {
        return UIManager.getFont("Table.font");
    }

    public boolean isTopPainted() {
        return this.m_top;
    }

    public boolean isLeftPainted() {
        return this.m_left;
    }

    public boolean isBottomPainted() {
        return this.m_bottom;
    }

    public boolean isRightPainted() {
        return this.m_right;
    }

    public void setIncludeTitle(boolean bl) {
        this.m_include_title = bl;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public void setJustification(int n) {
        this.m_justification = n;
    }

    public void setPosition(int n) {
        this.m_position = n;
    }

    public void setTextColorProperty(ColorProperty colorProperty) {
        this.m_text_color.setValue(colorProperty);
    }

    public void setTopPainted(boolean bl) {
        this.m_top = bl;
    }

    public void setLeftPainted(boolean bl) {
        this.m_left = bl;
    }

    public void setBottomPainted(boolean bl) {
        this.m_bottom = bl;
    }

    public void setRightPainted(boolean bl) {
        this.m_right = bl;
    }

    public void setValue(Object object) {
        if (object instanceof BorderProperty) {
            BorderProperty borderProperty = (BorderProperty)object;
            this.m_include_title = borderProperty.m_include_title;
            this.m_title = borderProperty.m_title;
            this.m_justification = borderProperty.m_justification;
            this.m_position = borderProperty.m_position;
            this.m_text_color = borderProperty.m_text_color;
            this.m_top = borderProperty.m_top;
            this.m_left = borderProperty.m_left;
            this.m_bottom = borderProperty.m_bottom;
            this.m_right = borderProperty.m_right;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static String toPositionString(int n) {
        switch (n) {
            case 1: {
                return "ABOVE_TOP";
            }
            case 2: {
                return "TOP";
            }
            case 3: {
                return "BELOW_TOP";
            }
            case 4: {
                return "ABOVE_BOTTOM";
            }
            case 5: {
                return "BOTTOM";
            }
            case 6: {
                return "BELOW_BOTTOM";
            }
        }
        return "DEFAULT_POSITION";
    }

    public static String toJustificationString(int n) {
        switch (n) {
            case 1: {
                return "LEFT";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "RIGHT";
            }
            case 4: {
                return "LEADING";
            }
            case 5: {
                return "TRAILING";
            }
        }
        return "DEFAULT_JUSTIFICATION";
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        if (n == 1) {
            this.m_title = (String)jETAObjectInput.readObject("title");
        } else {
            this.m_include_title = jETAObjectInput.readBoolean("includetitle", false);
            this.m_title = (String)jETAObjectInput.readObject("title");
            this.m_justification = jETAObjectInput.readInt("justification", 0);
            this.m_position = jETAObjectInput.readInt("position", 0);
            Object object = jETAObjectInput.readObject("textcolor");
            if (object instanceof Color) {
                this.m_text_color.setConstantColor((Color)object);
            } else if (object instanceof ColorProperty) {
                this.m_text_color = (ColorProperty)object;
            } else if (object != null) {
                System.out.println("BorderProperty: Unknown object:  " + object);
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            if (this.m_text_color == null) {
                this.m_text_color = new ColorProperty("TitledBorder.titleColor");
            }
            if (n > 2) {
                this.m_top = jETAObjectInput.readBoolean("top", true);
                this.m_left = jETAObjectInput.readBoolean("left", true);
                this.m_bottom = jETAObjectInput.readBoolean("bottom", true);
                this.m_right = jETAObjectInput.readBoolean("right", true);
            }
        }
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(JETAProperty.class));
        jETAObjectOutput.writeVersion(4);
        jETAObjectOutput.writeBoolean("includetitle", this.m_include_title, false);
        jETAObjectOutput.writeObject("title", this.m_title);
        jETAObjectOutput.writeInt("justification", this.m_justification, 0);
        jETAObjectOutput.writeInt("position", this.m_position, 0);
        if (DEFAULT_TEXT_COLOR.equals(this.m_text_color)) {
            jETAObjectOutput.writeObject("textcolor", this.m_text_color);
        } else {
            jETAObjectOutput.writeObject("textcolor", null);
        }
        jETAObjectOutput.writeBoolean("top", this.m_top, true);
        jETAObjectOutput.writeBoolean("left", this.m_left, true);
        jETAObjectOutput.writeBoolean("bottom", this.m_bottom, true);
        jETAObjectOutput.writeBoolean("right", this.m_right, true);
    }

    public void updateBean(JETABean jETABean) {
        Component component = null;
        if (jETABean != null) {
            component = jETABean.getDelegate();
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(this.createBorder(component));
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !BorderProperty.class.desiredAssertionStatus();
        DEFAULT_TEXT_COLOR = new ColorProperty("TitledBorder.titleColor");
    }
}

