/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.ParagraphSplitter;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.bidi.SimpleBidiSplitterFactory;
import com.openhtmltopdf.context.ContentFunctionFactory;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FSCanvas;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.BlockFormattingContext;
import com.openhtmltopdf.layout.BreakAtLineContext;
import com.openhtmltopdf.layout.FootnoteManager;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutState;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.layout.StyleTracker;
import com.openhtmltopdf.layout.counter.AbstractCounterContext;
import com.openhtmltopdf.layout.counter.CounterContext;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.MarkerData;
import com.openhtmltopdf.render.PageBox;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class LayoutContext
implements CssContext {
    private BlockBoxingState _blockBoxingState = BlockBoxingState.NOT_SET;
    private SharedContext _sharedContext;
    private Layer _rootLayer;
    private StyleTracker _firstLines;
    private StyleTracker _firstLetters;
    private MarkerData _currentMarkerData;
    private LinkedList<BlockFormattingContext> _bfcs;
    private LinkedList<Layer> _layers;
    private FontContext _fontContext;
    private final ContentFunctionFactory _contentFunctionFactory = new ContentFunctionFactory();
    private int _extraSpaceTop;
    private int _extraSpaceBottom;
    public final Map<CalculatedStyle, CounterContext> _counterContextMap = new HashMap<CalculatedStyle, CounterContext>();
    private String _pendingPageName;
    private String _pageName;
    private int _noPageBreak = 0;
    private Layer _rootDocumentLayer;
    private PageBox _page;
    private boolean _mayCheckKeepTogether = true;
    private boolean _lineBreakedBecauseOfNoWrap = false;
    private BreakAtLineContext _breakAtLineContext;
    private Boolean isPrintOverride = null;
    private boolean _isInFloatBottom;
    private LayoutState _savedLayoutState;
    private int _footnoteIndex;
    private FootnoteManager _footnoteManager;
    private boolean _isFootnoteAllowed = true;
    private final ParagraphSplitter _splitter = new ParagraphSplitter();
    private BidiSplitterFactory _bidiSplitterFactory = new SimpleBidiSplitterFactory();
    private byte _defaultTextDirection = 0;
    private BidiReorderer _bidiReorderer = new SimpleBidiReorderer();

    @Override
    public TextRenderer getTextRenderer() {
        return this._sharedContext.getTextRenderer();
    }

    @Override
    public StyleReference getCss() {
        return this._sharedContext.getCss();
    }

    public FSCanvas getCanvas() {
        return this._sharedContext.getCanvas();
    }

    public Rectangle getFixedRectangle() {
        return this._sharedContext.getFixedRectangle();
    }

    public NamespaceHandler getNamespaceHandler() {
        return this._sharedContext.getNamespaceHandler();
    }

    public ParagraphSplitter getParagraphSplitter() {
        return this._splitter;
    }

    public void setBidiReorderer(BidiReorderer reorderer) {
        this._bidiReorderer = reorderer;
    }

    public BidiReorderer getBidiReorderer() {
        return this._bidiReorderer;
    }

    public BidiSplitterFactory getBidiSplitterFactory() {
        return this._bidiSplitterFactory;
    }

    public void setBidiSplitterFactory(BidiSplitterFactory factory) {
        this._bidiSplitterFactory = factory;
    }

    public byte getDefaultTextDirection() {
        return this._defaultTextDirection;
    }

    public void setDefaultTextDirection(byte direction) {
        this._defaultTextDirection = direction;
    }

    LayoutContext(SharedContext sharedContext) {
        this._sharedContext = sharedContext;
        this._bfcs = new LinkedList();
        this._layers = new LinkedList();
        this._firstLines = StyleTracker.withNoStyles();
        this._firstLetters = StyleTracker.withNoStyles();
    }

    public void reInit(boolean keepLayers) {
        this._firstLines = StyleTracker.withNoStyles();
        this._firstLetters = StyleTracker.withNoStyles();
        this._currentMarkerData = null;
        this._bfcs = new LinkedList();
        if (!keepLayers) {
            this._rootLayer = null;
            this._layers = new LinkedList();
        }
        this._extraSpaceTop = 0;
        this._extraSpaceBottom = 0;
    }

    public LayoutState captureLayoutState() {
        if (!this.isPrint()) {
            return new LayoutState(this._bfcs, this._currentMarkerData, this._firstLetters, this._firstLines);
        }
        return new LayoutState(this._bfcs, this._currentMarkerData, this._firstLetters, this._firstLines, this.getPageName(), this.getExtraSpaceTop(), this.getExtraSpaceBottom(), this.getNoPageBreak());
    }

    public void restoreLayoutState(LayoutState layoutState) {
        this._firstLines = layoutState.getFirstLines();
        this._firstLetters = layoutState.getFirstLetters();
        this._currentMarkerData = layoutState.getCurrentMarkerData();
        this._bfcs = layoutState.getBFCs();
        if (this.isPrint()) {
            this.setPageName(layoutState.getPageName());
            this.setExtraSpaceBottom(layoutState.getExtraSpaceBottom());
            this.setExtraSpaceTop(layoutState.getExtraSpaceTop());
            this.setNoPageBreak(layoutState.getNoPageBreak());
        }
    }

    public LayoutState copyStateForRelayout() {
        if (this._savedLayoutState != null && this._savedLayoutState.equal(this._currentMarkerData, this._firstLetters, this._firstLines, this.isPrint() ? this.getPageName() : null)) {
            return this._savedLayoutState;
        }
        this._savedLayoutState = new LayoutState(this._firstLetters, this._firstLines, this._currentMarkerData, this.isPrint() ? this.getPageName() : null);
        return this._savedLayoutState;
    }

    public void restoreStateForRelayout(LayoutState layoutState) {
        this._firstLines = layoutState.getFirstLines();
        this._firstLetters = layoutState.getFirstLetters();
        this._currentMarkerData = layoutState.getCurrentMarkerData();
        if (this.isPrint()) {
            this.setPageName(layoutState.getPageName());
        }
    }

    public BlockFormattingContext getBlockFormattingContext() {
        return this._bfcs.getLast();
    }

    public void pushBFC(BlockFormattingContext bfc) {
        this._bfcs.add(bfc);
    }

    public void popBFC() {
        this._bfcs.removeLast();
    }

    public void pushLayerIsolated(Box master) {
        this.pushLayer(new Layer(master, this, true));
    }

    public void pushLayer(Box master) {
        Layer layer = null;
        if (this._rootLayer == null) {
            this._rootLayer = layer = new Layer(master, this);
        } else {
            Layer parent = this.getLayer();
            layer = new Layer(parent, master, this);
            parent.addChild(layer);
        }
        this.pushLayer(layer);
    }

    public void pushLayer(Layer layer) {
        this._layers.add(layer);
    }

    public void popLayer() {
        Layer layer = this.getLayer();
        layer.finish(this);
        this._layers.removeLast();
    }

    public Layer getLayer() {
        return this._layers.getLast();
    }

    public Layer getRootLayer() {
        return this._rootLayer;
    }

    public void translate(int x, int y) {
        this.getBlockFormattingContext().translate(x, y);
    }

    public void addBoxId(String id, Box box) {
        this._sharedContext.addBoxId(id, box);
    }

    public void removeBoxId(String id) {
        this._sharedContext.removeBoxId(id);
    }

    public boolean isInteractive() {
        return this._sharedContext.isInteractive();
    }

    @Override
    public float getMmPerDot() {
        return this._sharedContext.getMmPerDotParent();
    }

    @Override
    public int getDotsPerPixel() {
        return this._sharedContext.getDotsPerPixel();
    }

    @Override
    public float getFontSize2D(FontSpecification font) {
        return this._sharedContext.getFont(font).getSize2D();
    }

    @Override
    public float getXHeight(FontSpecification parentFont) {
        return this._sharedContext.getXHeight(this.getFontContext(), parentFont);
    }

    @Override
    public FSFont getFont(FontSpecification font) {
        return this._sharedContext.getFont(font);
    }

    public UserAgentCallback getUac() {
        return this._sharedContext.getUserAgentCallback();
    }

    public boolean isPrint() {
        if (this.isPrintOverride != null) {
            return this.isPrintOverride;
        }
        return this._sharedContext.isPrint();
    }

    public void setIsPrintOverride(Boolean isPrint) {
        this.isPrintOverride = isPrint;
    }

    public StyleTracker getFirstLinesTracker() {
        return this._firstLines;
    }

    public StyleTracker getFirstLettersTracker() {
        return this._firstLetters;
    }

    public MarkerData getCurrentMarkerData() {
        return this._currentMarkerData;
    }

    public void setCurrentMarkerData(MarkerData currentMarkerData) {
        this._currentMarkerData = currentMarkerData;
    }

    public ReplacedElementFactory getReplacedElementFactory() {
        return this._sharedContext.getReplacedElementFactory();
    }

    @Override
    public FontContext getFontContext() {
        return this._fontContext;
    }

    public void setFontContext(FontContext fontContext) {
        this._fontContext = fontContext;
    }

    public ContentFunctionFactory getContentFunctionFactory() {
        return this._contentFunctionFactory;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public int getExtraSpaceBottom() {
        return this._extraSpaceBottom;
    }

    public void setExtraSpaceBottom(int extraSpaceBottom) {
        this._extraSpaceBottom = extraSpaceBottom;
    }

    public int getExtraSpaceTop() {
        return this._extraSpaceTop;
    }

    public void setExtraSpaceTop(int extraSpaceTop) {
        this._extraSpaceTop = extraSpaceTop;
    }

    public void resolveCounters(CalculatedStyle style, Integer startIndex) {
        CounterContext cc = new CounterContext(this, style, startIndex);
        this._counterContextMap.put(style, cc);
    }

    public void resolveCounters(CalculatedStyle style) {
        this.resolveCounters(style, null);
    }

    public AbstractCounterContext getCounterContext(CalculatedStyle style) {
        return this._counterContextMap.get(style);
    }

    @Override
    public FSFontMetrics getFSFontMetrics(FSFont font) {
        return this.getTextRenderer().getFSFontMetrics(this.getFontContext(), font, "");
    }

    public String getPageName() {
        return this._pageName;
    }

    public void setPageName(String currentPageName) {
        this._pageName = currentPageName;
    }

    public int getNoPageBreak() {
        return this._noPageBreak;
    }

    public void setNoPageBreak(int noPageBreak) {
        this._noPageBreak = noPageBreak;
    }

    public boolean isPageBreaksAllowed() {
        return this._noPageBreak == 0;
    }

    public String getPendingPageName() {
        return this._pendingPageName;
    }

    public void setPendingPageName(String pendingPageName) {
        this._pendingPageName = pendingPageName;
    }

    public Layer getRootDocumentLayer() {
        return this._rootDocumentLayer;
    }

    public void setRootDocumentLayer(Layer rootDocumentLayer) {
        this._rootDocumentLayer = rootDocumentLayer;
    }

    public PageBox getPage() {
        return this._page;
    }

    public void setPage(PageBox page) {
        this._page = page;
    }

    public boolean isMayCheckKeepTogether() {
        return this._mayCheckKeepTogether;
    }

    public void setMayCheckKeepTogether(boolean mayKeepTogether) {
        this._mayCheckKeepTogether = mayKeepTogether;
    }

    public void setBlockBoxingState(BlockBoxingState state) {
        this._blockBoxingState = state;
    }

    public BlockBoxingState getBlockBoxingState() {
        return this._blockBoxingState;
    }

    public boolean isLineBreakedBecauseOfNoWrap() {
        return this._lineBreakedBecauseOfNoWrap;
    }

    public void setLineBreakedBecauseOfNoWrap(boolean value) {
        this._lineBreakedBecauseOfNoWrap = value;
    }

    public BreakAtLineContext getBreakAtLineContext() {
        return this._breakAtLineContext;
    }

    public void setBreakAtLineContext(BreakAtLineContext breakAtLineContext) {
        this._breakAtLineContext = breakAtLineContext;
    }

    public boolean isFootnoteAllowed() {
        return this._isFootnoteAllowed;
    }

    public void setFootnoteAllowed(boolean allowed) {
        this._isFootnoteAllowed = allowed;
    }

    public void setIsInFloatBottom(boolean inFloatBottom) {
        this._isInFloatBottom = inFloatBottom;
    }

    @Override
    public boolean isInFloatBottom() {
        return this._isInFloatBottom;
    }

    public void setFootnoteIndex(int footnoteIndex) {
        this._footnoteIndex = footnoteIndex;
    }

    public int getFootnoteIndex() {
        return this._footnoteIndex;
    }

    public boolean hasActiveFootnotes() {
        return this._footnoteManager != null;
    }

    public FootnoteManager getFootnoteManager() {
        if (this._footnoteManager == null) {
            this._footnoteManager = new FootnoteManager();
        }
        return this._footnoteManager;
    }

    public void setFirstLettersTracker(StyleTracker firstLetters) {
        this._firstLetters = firstLetters;
    }

    public void setFirstLinesTracker(StyleTracker firstLines) {
        this._firstLines = firstLines;
    }

    public static enum BlockBoxingState {
        NOT_SET,
        ALLOW,
        DENY;

    }
}

