/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolverFactory;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.jcache.annotation.Contracts;
import org.infinispan.jcache.annotation.DefaultCacheKeyGenerator;
import org.infinispan.jcache.logging.Log;

public final class CacheLookupHelper {
    private static final Log log = (Log)LogFactory.getLog(CacheLookupHelper.class, Log.class);

    private CacheLookupHelper() {
    }

    public static String getCacheName(Method method, String methodCacheName, CacheDefaults cacheDefaultsAnnotation, boolean generate) {
        Contracts.assertNotNull(method, "method parameter must not be null");
        Contracts.assertNotNull(methodCacheName, "methodCacheName parameter must not be null");
        String cacheName = methodCacheName.trim();
        if (cacheName.isEmpty() && cacheDefaultsAnnotation != null) {
            cacheName = cacheDefaultsAnnotation.cacheName().trim();
        }
        if (cacheName.isEmpty() && generate) {
            cacheName = CacheLookupHelper.getDefaultMethodCacheName(method);
        }
        return cacheName;
    }

    public static CacheKeyGenerator getCacheKeyGenerator(BeanManager beanManager, Class<? extends CacheKeyGenerator> methodCacheKeyGeneratorClass, CacheDefaults cacheDefaultsAnnotation) {
        Contracts.assertNotNull(beanManager, "beanManager parameter must not be null");
        Class cacheKeyGeneratorClass = DefaultCacheKeyGenerator.class;
        if (!CacheKeyGenerator.class.equals(methodCacheKeyGeneratorClass)) {
            cacheKeyGeneratorClass = methodCacheKeyGeneratorClass;
        } else if (cacheDefaultsAnnotation != null && !CacheKeyGenerator.class.equals((Object)cacheDefaultsAnnotation.cacheKeyGenerator())) {
            cacheKeyGeneratorClass = cacheDefaultsAnnotation.cacheKeyGenerator();
        }
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        Set beans = beanManager.getBeans((Type)cacheKeyGeneratorClass, new Annotation[0]);
        if (!beans.isEmpty()) {
            Bean bean = beanManager.resolve(beans);
            return (CacheKeyGenerator)beanManager.getReference(bean, CacheKeyGenerator.class, creationalContext);
        }
        try {
            return (CacheKeyGenerator)cacheKeyGeneratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw log.unableToInstantiateCacheKeyGenerator(cacheKeyGeneratorClass, (Throwable)e);
        }
    }

    public static CacheResolverFactory getCacheResolverFactory(BeanManager beanManager, Class<? extends CacheResolverFactory> methodCacheResolverFactoryClass, CacheDefaults cacheDefaultsAnnotation) {
        Contracts.assertNotNull(beanManager, "beanManager parameter must not be null");
        Class cacheResolverFactoryClass = null;
        if (!CacheResolverFactory.class.equals(methodCacheResolverFactoryClass)) {
            cacheResolverFactoryClass = methodCacheResolverFactoryClass;
        } else if (cacheDefaultsAnnotation != null && !CacheResolverFactory.class.equals((Object)cacheDefaultsAnnotation.cacheResolverFactory())) {
            cacheResolverFactoryClass = cacheDefaultsAnnotation.cacheResolverFactory();
        }
        if (cacheResolverFactoryClass == null) {
            return null;
        }
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        Set beans = beanManager.getBeans((Type)cacheResolverFactoryClass, new Annotation[0]);
        if (!beans.isEmpty()) {
            Bean bean = beanManager.resolve(beans);
            return (CacheResolverFactory)beanManager.getReference(bean, CacheResolverFactory.class, creationalContext);
        }
        try {
            return (CacheResolverFactory)cacheResolverFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw log.unableToInstantiateCacheResolverFactory(cacheResolverFactoryClass, (Throwable)e);
        }
    }

    private static String getDefaultMethodCacheName(Method method) {
        int i = 0;
        int nbParameters = method.getParameterCount();
        StringBuilder cacheName = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        for (Class<?> oneParameterType : method.getParameterTypes()) {
            cacheName.append(oneParameterType.getName());
            if (i < nbParameters - 1) {
                cacheName.append(",");
            }
            ++i;
        }
        return cacheName.append(")").toString();
    }
}

