/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;

public class NullableDiscriminatorColumnSecondPass
implements SecondPass {
    private final String rootEntityName;

    public NullableDiscriminatorColumnSecondPass(String rootEntityName) {
        this.rootEntityName = rootEntityName;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        PersistentClass rootPersistenceClass = persistentClasses.get(this.rootEntityName);
        if (this.hasNullDiscriminatorValue(rootPersistenceClass)) {
            for (Selectable selectable : rootPersistenceClass.getDiscriminator().getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                ((Column)selectable).setNullable(true);
            }
        }
    }

    private boolean hasNullDiscriminatorValue(PersistentClass rootPersistenceClass) {
        if (rootPersistenceClass.isDiscriminatorValueNull()) {
            return true;
        }
        for (Subclass subclass : rootPersistenceClass.getSubclasses()) {
            if (!subclass.isDiscriminatorValueNull()) continue;
            return true;
        }
        return false;
    }
}

