/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Map;
import java.util.function.Function;
import org.infinispan.cache.impl.AbstractCacheBackedSet;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ForwardingCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.stream.StreamMarshalling;

public class CacheBackedEntrySet<K, V>
extends AbstractCacheBackedSet<K, V, CacheEntry<K, V>> {
    public CacheBackedEntrySet(CacheImpl<K, V> cache, Object lockOwner, long explicitFlags) {
        super(cache, lockOwner, explicitFlags);
    }

    @Override
    public boolean contains(Object o) {
        Object cacheValue;
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        InvocationContext ctx = this.cache.invocationContextFactory.createInvocationContext(false, 1);
        if (this.lockOwner != null) {
            ctx.setLockOwner(this.lockOwner);
        }
        return (cacheValue = this.cache.get(entry.getKey(), this.explicitFlags, ctx)) != null && cacheValue.equals(entry.getValue());
    }

    @Override
    protected Function<Map.Entry<K, V>, ?> entryToKeyFunction() {
        return StreamMarshalling.entryToKeyFunction();
    }

    @Override
    protected Object extractKey(Object e) {
        if (!(e instanceof Map.Entry)) {
            return null;
        }
        return ((Map.Entry)e).getKey();
    }

    @Override
    protected CacheEntry<K, V> wrapElement(final CacheEntry<K, V> e) {
        return new ForwardingCacheEntry<K, V>(){

            @Override
            protected CacheEntry<K, V> delegate() {
                return e;
            }

            @Override
            public V setValue(V value) {
                CacheBackedEntrySet.this.cache.put(this.getKey(), value, CacheBackedEntrySet.this.cache.defaultMetadata, 0L, CacheBackedEntrySet.this.decoratedWriteContextBuilder());
                return super.setValue(value);
            }
        };
    }
}

