/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.PathHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.TerminalPathException;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicSqmPathSource<J>
extends AbstractSqmPathSource<J>
implements ReturnableType<J> {
    private final JavaType<?> relationalJavaType;
    private final boolean isGeneric;

    public BasicSqmPathSource(String localPathName, SqmPathSource<J> pathModel, BasicDomainType<J> domainType, JavaType<?> relationalJavaType, Bindable.BindableType jpaBindableType, boolean isGeneric) {
        super(localPathName, pathModel, domainType, jpaBindableType);
        this.relationalJavaType = relationalJavaType;
        this.isGeneric = isGeneric;
    }

    @Override
    public BasicDomainType<J> getSqmPathType() {
        return (BasicDomainType)super.getSqmPathType();
    }

    @Override
    public DomainType<J> getSqmType() {
        return this.getSqmPathType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        String path = this.pathModel.getPathName();
        String pathDesc = path == null || path.startsWith("{") ? " " : " '" + this.pathModel.getPathName() + "' ";
        throw new TerminalPathException("Terminal path" + pathDesc + "has no attribute '" + name + "'");
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        return new SqmBasicValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this.pathModel, lhs, lhs.nodeBuilder());
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    public Class<J> getJavaType() {
        return this.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.relationalJavaType;
    }

    @Override
    public boolean isGeneric() {
        return this.isGeneric;
    }

    public String toString() {
        return "BasicSqmPathSource(" + this.getPathName() + " : " + this.getJavaType().getSimpleName() + ")";
    }
}

