/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.security;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.session.ReactiveSessionInformation;
import org.springframework.security.core.session.ReactiveSessionRegistry;
import org.springframework.session.ReactiveFindByIndexNameSessionRepository;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SpringSessionBackedReactiveSessionRegistry<S extends Session>
implements ReactiveSessionRegistry {
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private final ReactiveSessionRepository<S> sessionRepository;
    private final ReactiveFindByIndexNameSessionRepository<S> indexedSessionRepository;

    public SpringSessionBackedReactiveSessionRegistry(ReactiveSessionRepository<S> sessionRepository, ReactiveFindByIndexNameSessionRepository<S> indexedSessionRepository) {
        Assert.notNull(sessionRepository, (String)"sessionRepository cannot be null");
        Assert.notNull(indexedSessionRepository, (String)"indexedSessionRepository cannot be null");
        this.sessionRepository = sessionRepository;
        this.indexedSessionRepository = indexedSessionRepository;
    }

    public Flux<ReactiveSessionInformation> getAllSessions(Object principal) {
        Authentication authenticationToken = SpringSessionBackedReactiveSessionRegistry.getAuthenticationToken(principal);
        return this.indexedSessionRepository.findByPrincipalName(authenticationToken.getName()).flatMapMany(sessionMap -> Flux.fromIterable(sessionMap.entrySet())).map(entry -> new SpringSessionBackedReactiveSessionInformation(this, (Session)entry.getValue()));
    }

    public Mono<Void> saveSessionInformation(ReactiveSessionInformation information) {
        return Mono.empty();
    }

    public Mono<ReactiveSessionInformation> getSessionInformation(String sessionId) {
        return this.sessionRepository.findById(sessionId).map(x$0 -> new SpringSessionBackedReactiveSessionInformation(this, x$0));
    }

    public Mono<ReactiveSessionInformation> removeSessionInformation(String sessionId) {
        return Mono.empty();
    }

    public Mono<ReactiveSessionInformation> updateLastAccessTime(String sessionId) {
        return Mono.empty();
    }

    private static Authentication getAuthenticationToken(final Object principal) {
        return new AbstractAuthenticationToken(AuthorityUtils.NO_AUTHORITIES){

            public Object getCredentials() {
                return null;
            }

            public Object getPrincipal() {
                return principal;
            }
        };
    }

    static class SpringSessionBackedReactiveSessionInformation
    extends ReactiveSessionInformation {
        final /* synthetic */ SpringSessionBackedReactiveSessionRegistry this$0;

        SpringSessionBackedReactiveSessionInformation(S session) {
            this.this$0 = this$0;
            super((Object)SpringSessionBackedReactiveSessionInformation.resolvePrincipalName(session), session.getId(), session.getLastAccessedTime());
        }

        private static String resolvePrincipalName(Session session) {
            String principalName = (String)session.getAttribute("PRINCIPAL_NAME_INDEX_NAME");
            if (principalName != null) {
                return principalName;
            }
            SecurityContext securityContext = (SecurityContext)session.getAttribute(SpringSessionBackedReactiveSessionRegistry.SPRING_SECURITY_CONTEXT);
            if (securityContext != null && securityContext.getAuthentication() != null) {
                return securityContext.getAuthentication().getName();
            }
            return "";
        }

        public Mono<Void> invalidate() {
            return super.invalidate().then(Mono.defer(() -> this.this$0.sessionRepository.deleteById(this.getSessionId())));
        }
    }
}

