/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.validator;

import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.validator.InvalidArchive;
import com.xebialabs.plugin.manager.validator.JarSyntheticExtractor;
import com.xebialabs.plugin.manager.validator.PluginValid;
import com.xebialabs.plugin.manager.validator.ReloadableSyntheticExtractor;
import com.xebialabs.plugin.manager.validator.SyntheticExtractor;
import com.xebialabs.plugin.manager.validator.SyntheticValidatorAtInstallation;
import com.xebialabs.plugin.manager.validator.TypeDefinitionNotValid;
import com.xebialabs.plugin.manager.validator.ValidationResult;
import com.xebialabs.plugin.manager.validator.ValidatorUtils$;
import com.xebialabs.plugin.manager.validator.XldpSyntheticExtractor;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.ZipFile;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.slf4j.Marker;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005]3Aa\u0002\u0005\u0001'!)!\u0005\u0001C\u0001G!9\u0011\u0002\u0001b\u0001\n\u00131\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u0003?\u0001\u0011%q\bC\u0003K\u0001\u0011%1JA\bQYV<\u0017N\u001c,bY&$\u0017\r^8s\u0015\tI!\"A\u0005wC2LG-\u0019;pe*\u00111\u0002D\u0001\b[\u0006t\u0017mZ3s\u0015\tia\"\u0001\u0004qYV<\u0017N\u001c\u0006\u0003\u001fA\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003E\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006g24GG\u001b\u0006\u0002?\u0005AqM]5{u2,G-\u0003\u0002\"9\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\t+\u00059\u0003CA\u0013)\u0013\tI\u0003B\u0001\u0011Ts:$\b.\u001a;jGZ\u000bG.\u001b3bi>\u0014\u0018\t^%ogR\fG\u000e\\1uS>t\u0017A\u0003<bY&$\u0017\r^8sA\u0005Aa/\u00197jI\u0006$X\rF\u0002.aa\u0002\"!\n\u0018\n\u0005=B!\u0001\u0005,bY&$\u0017\r^5p]J+7/\u001e7u\u0011\u0015\tD\u00011\u00013\u0003\u0015\u0011\u0017\u0010^3t!\r)2'N\u0005\u0003iY\u0011Q!\u0011:sCf\u0004\"!\u0006\u001c\n\u0005]2\"\u0001\u0002\"zi\u0016DQ!\u000f\u0003A\u0002i\n\u0001\u0002\u001d7vO&t\u0017\n\u001a\t\u0003wqj\u0011AC\u0005\u0003{)\u0011\u0001\u0002\u00157vO&t\u0017\nZ\u0001\rO\u0016$X\t\u001f;sC\u000e$xN\u001d\u000b\u0003\u0001&\u00032!\u0011#G\u001b\u0005\u0011%BA\"\u0017\u0003\u0011)H/\u001b7\n\u0005\u0015\u0013%a\u0001+ssB\u0011QeR\u0005\u0003\u0011\"\u0011!cU=oi\",G/[2FqR\u0014\u0018m\u0019;pe\")\u0011(\u0002a\u0001u\u0005\u0001b/\u00197jI\u0006$X-\u00138uKJt\u0017\r\u001c\u000b\u0004[13\u0006\"B'\u0007\u0001\u0004q\u0015A\u00039mk\u001eLgNR5mKB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0003S>T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V!\n!a)\u001b7f\u0011\u0015Id\u00011\u0001;\u0001")
public class PluginValidator
implements Logging {
    private final SyntheticValidatorAtInstallation validator;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginValidator pluginValidator = this;
        synchronized (pluginValidator) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private SyntheticValidatorAtInstallation validator() {
        return this.validator;
    }

    public ValidationResult validate(byte[] bytes, PluginId pluginId) {
        ValidationResult validationResult;
        File pluginFile = ValidatorUtils$.MODULE$.createFileInWorkFolderFrom(bytes, "validation-" + pluginId.name());
        Try zipFile = Try$.MODULE$.apply((Function0 & Serializable)() -> new ZipFile(pluginFile));
        if (zipFile.isSuccess()) {
            ((ZipFile)zipFile.get()).close();
            validationResult = this.validateInternal(pluginFile, pluginId);
        } else {
            validationResult = new InvalidArchive(pluginId.name());
        }
        InvalidArchive result = validationResult;
        PathUtils.deleteDirectory((Path)pluginFile.getParentFile().toPath(), (LinkOption[])PathUtils.EMPTY_LINK_OPTION_ARRAY, (DeleteOption[])new DeleteOption[0]);
        return result;
    }

    private Try<SyntheticExtractor> getExtractor(PluginId pluginId) {
        String extension;
        String string;
        PluginId pluginId2 = pluginId;
        if (pluginId2 instanceof PluginId.LocalFile) {
            String extension2;
            PluginId.LocalFile localFile = (PluginId.LocalFile)pluginId2;
            string = extension2 = localFile.extension();
        } else if (pluginId2 instanceof PluginId.Artifact) {
            String packaging;
            PluginId.Artifact artifact = (PluginId.Artifact)pluginId2;
            string = packaging = artifact.packaging();
        } else {
            throw new MatchError((Object)pluginId2);
        }
        String string2 = extension = string;
        String string3 = ConfigWrapper$.MODULE$.EXTENSION_JAR();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return new Success((Object)new JarSyntheticExtractor());
        }
        String string5 = ConfigWrapper$.MODULE$.EXTENSION_XLDP();
        String string6 = string2;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            return new Success((Object)new XldpSyntheticExtractor());
        }
        String string7 = ConfigWrapper$.MODULE$.EXTENSION_ZIP();
        String string8 = string2;
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            return new Success((Object)new ReloadableSyntheticExtractor());
        }
        return new Failure((Throwable)new IllegalArgumentException("unsupported plugin extension " + extension));
    }

    private ValidationResult validateInternal(File pluginFile, PluginId pluginId) {
        Try try_;
        Some some;
        Try<SyntheticExtractor> try_2 = this.getExtractor(pluginId);
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            SyntheticExtractor extractor = (SyntheticExtractor)success.value();
            some = extractor.extractFrom(pluginFile, pluginId);
        } else if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable exception = failure.exception();
            some = new Some((Object)new Failure(exception));
        } else {
            throw new MatchError(try_2);
        }
        Some syntheticOpt = some;
        boolean bl = false;
        Some some2 = null;
        Some some3 = syntheticOpt;
        if (some3 instanceof Some) {
            bl = true;
            some2 = some3;
            Try try_3 = (Try)some2.value();
            if (try_3 instanceof Success) {
                Success success = (Success)try_3;
                List types = (List)success.value();
                return this.validator().validate((List<TypeSpecification>)types);
            }
        }
        if (bl && (try_ = (Try)some2.value()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().debug((Function0 & Serializable)() -> "Type validation failed. Invalid xml or yaml. Message: " + exception.getMessage());
            return new TypeDefinitionNotValid(pluginId.name());
        }
        if (None$.MODULE$.equals(some3)) {
            return new PluginValid();
        }
        throw new MatchError((Object)some3);
    }

    public PluginValidator() {
        Logging.$init$((Logging)this);
        this.validator = new SyntheticValidatorAtInstallation();
    }
}

