/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.constants;

import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public final class ValueConstants {
    private static final Map<Short, String> sacTypesStrings = new HashMap<Short, String>(25);

    public static String stringForSACPrimitiveType(short type) {
        return sacTypesStrings.get(type);
    }

    public static boolean isAbsoluteUnit(short type) {
        switch (type) {
            case 2: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
            case 0: {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.CASCADE_IS_ABSOLUTE_CSS_UNKNOWN_GIVEN, new Exception());
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isNumber(short cssPrimitiveType) {
        switch (cssPrimitiveType) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    static {
        sacTypesStrings.put((short)3, "em");
        sacTypesStrings.put((short)4, "ex");
        sacTypesStrings.put((short)5, "px");
        sacTypesStrings.put((short)2, "%");
        sacTypesStrings.put((short)8, "in");
        sacTypesStrings.put((short)6, "cm");
        sacTypesStrings.put((short)7, "mm");
        sacTypesStrings.put((short)9, "pt");
        sacTypesStrings.put((short)10, "pc");
    }
}

